% Draws Figure 25.1 for 
% Scientific Computing with Case Studies
% Dianne P. O'Leary
% SIAM Press, 2009


l3 = 2.5     %line width

% Base:

a = [0 0 0];
b = [0 2 0];
c = [1 .5 0];

% Top:

%cbar = [1 .1 1];
%bbar = [.2 1.2 1];
%abar = [0 0 1];

cbar = [0 0 1];
abar = [.1 1.1 1];
bbar = [1.1  .6 1];

offset = .05*[1 1 1];

hold off
base = [a;b;c];
top = [abar;bbar;cbar];

% Draw base and label vertices 

figure
plot3(base(1:2,1),base(1:2,2),base(1:2,3),'LineWidth',l3) %ab
hold on
plot3(base(2:3,1),base(2:3,2),base(2:3,3),'LineWidth',l3) %bc
plot3(base([1,3],1),base([1,3],2),base([1,3],3),'LineWidth',l3) %ac

txt = text;
set(txt,'position',a-offset,'string',{'A_1'})
txt = text;
set(txt,'position',b-offset,'string',{'B_1'})
txt = text;
set(txt,'position',c-offset,'string',{'C_1'})

% Draw top and label vertices 

txt = text;
set(txt,'position',abar+offset,'string',{'A_2'})
txt = text;
set(txt,'position',bbar+offset,'string',{'B_2'})
txt = text;
set(txt,'position',cbar+offset/2,'string',{'C_2'})

plot3(top(1:2,1),top(1:2,2),top(1:2,3),'r','LineWidth',l3) %ab
hold on
plot3(top(2:3,1),top(2:3,2),top(2:3,3),'r','LineWidth',l3) %bc
plot3(top([1,3],1),top([1,3],2),top([1,3],3),'r','LineWidth',l3) %ac

abbar = [base(1,:);top(2,:)];
acbar = [base(1,:);top(3,:)];

l3 = .8*l3;

plot3(abbar(:,1),abbar(:,2),abbar(:,3),'k','LineWidth',l3);
plot3(acbar(:,1),acbar(:,2),acbar(:,3),'k','LineWidth',l3);

bcbar = [base(2,:);top(3,:)];
babar = [base(2,:);top(1,:)];

plot3(bcbar(:,1),bcbar(:,2),bcbar(:,3),'k','LineWidth',l3);
plot3(babar(:,1),babar(:,2),babar(:,3),'k','LineWidth',l3);

cbbar = [base(3,:);top(2,:)];
cabar = [base(3,:);top(1,:)];

plot3(cbbar(:,1),cbbar(:,2),cbbar(:,3),'k','LineWidth',l3);
plot3(cabar(:,1),cabar(:,2),cabar(:,3),'k','LineWidth',l3);

axis off

view(-39.81,10.14)
