
function F = homogeom(theta)

% function F = homogeom(theta)
% Evaluation function for homotopy method for geometric method.
% It averages the desired lengths for the top trusses with those 
% for the known one.
%
% Input:  theta = 3 angles for the vertical truss planes
% Output: F = residuals of equations for lengths of top trusses
%
% Dianne P. O'Leary 05/2008

% Compute the length of the top trusses, an average of those for 
% the "easy" problem and those for the desired one.

global myl_vert myl_bott myl_top mylambda mythetatrue myscale myl_top_easy

l_top = mylambda * myl_top + (1 - mylambda) * myl_top_easy;

% Evaluate the truss function based on these lengths.

F = trusscheck(theta,myl_vert,myl_bott,l_top,0);





