
function F = homopoly(tangents)

% function F = homopoly(tangents)
% Evaluation function for homotopy method for polynomial method.
%
% Input:  tangents = 3 tangents for the vertical truss planes
% Output: F = residuals of polynomial equations 
%
% Dianne P. O'Leary 05/2008

global myl_vert myl_bott myl_top mylambda mythetatrue myscale

% Evaluate the "easy" polynomial Feasy.

f11 = tangents(1)^2-1;
f14 = tangents(1)^2-4;

f21 = tangents(2)^2-1;
f29 = tangents(2)^2-9;

f34 = tangents(3)^2-4;
f39 = tangents(3)^2-9;

Feasy = [
         f14*f29, ... 
         f21*f34, ... 
         f39*f11            
         ];

% Evaluate the truss polynomial Ftruss.

Ftruss = polytruss(tangents,myl_vert,myl_bott,myl_top,0);

% Now average the values to get the homotopy function.

F = mylambda * Ftruss + (1 - mylambda) * Feasy;




