function [thetanonlin,thetahomotop] = methodgeom(probname,karun,wantplotf,wantploth)

global myl_vert myl_bott myl_top mylambda mythetatrue myscale myl_top_easy myhh myff myfangles myhangles

% Arun examples
% Solves the Watson truss problem using Fsolve, comparing
% with a homotopy method.
% The homotopy uses 64 different trusses, each in a different orthant.

% Set the scale for the easy problem.


myl_top_hard = myl_top;

% Generate the data for the easy function.

kstep = 10;

mythetatrue = [pi/6; 7*pi/16; pi/4]; 

options = optimset('Display','off','TolX',1.e-3,'TolFun',1.e-3);

% Generate the 64 starting points.

kmax = 64;

t1 = [  mythetatrue(1) 
       -mythetatrue(1)
     pi+mythetatrue(1)
     pi-mythetatrue(1)];
t2 = [  mythetatrue(2) 
       -mythetatrue(2)
     pi+mythetatrue(2)
     pi-mythetatrue(2)];
t3 = [  mythetatrue(3) 
       -mythetatrue(3)
     pi+mythetatrue(3)
     pi-mythetatrue(3)];

% Generate the 64 sets of starting angles, and store them in start.

s1 = t3;
s2 = [t2(1)*ones(4,1),s1;
      t2(2)*ones(4,1),s1;
      t2(3)*ones(4,1),s1;
      t2(4)*ones(4,1),s1];
s3 = [t1(1)*ones(16,1),s2;
      t1(2)*ones(16,1),s2;
      t1(3)*ones(16,1),s2;
      t1(4)*ones(16,1),s2];

start = s3';
mylambda = 0;


for k=1:kmax,

% Use fsolve to solve the problem, starting from the kth 
% starting point.

   myl_top = myl_top_hard;
   [theta,dum,fsolverept] = fsolve(@fevalgeom,start(:,k),options);
   [F,z,bottcoord,topcoord,lensbot,lensvert] = trusscheck(theta,myl_vert,myl_bott,myl_top_hard,0);

   disp(sprintf('Geometry Method: Arun truss problem %s starting point %d',probname,k))

   if (z==0)
     disp(sprintf('Fsolve reports %d. The Geometry Method fsolve truss is wrong; z=%d.',fsolverept,z))
     theta = zeros(3,1);
   else
     disp(sprintf('Fsolve reports %d. The Geometry Method fsolve truss is fine.',fsolverept))
   end

   thetanonlin(:,k) = theta;

% Use homotopy to solve the problem using the same starting point.
% Compute myl_top_easy using trusscheck.

   theta = start(:,k);
   [F,z,Tbott,Ttop,myl_top_easy] = trusscheck(theta,myl_vert,myl_bott, ...
                           ones(1,3),0);
   for j=1:kstep,
      mylambda = j/kstep;
      myl_top = (1-mylambda)*myl_top_easy + mylambda*myl_top_hard;
      [theta,dum,fsolverept] = fsolve(@homogeom,theta,options);
   end

   [F,z,bott,top] = trusscheck(theta,myl_vert,myl_bott,myl_top_hard,0);

   if (z < 2)
     disp(sprintf('Fsolve reports %d. The Geometry Method homotopy truss is wrong; z=%d.',fsolverept,z))
     theta = zeros(3,1);
   else
     disp(sprintf('Fsolve reports %d. The Geometry Method homotopy truss is fine.',fsolverept))
   end

   thetahomotop(:,k) = theta;

end % for 64 starting points

% Print a summary,

disp('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')

disp(sprintf('GEOMETRY METHOD ARUN TRUSS PROBLEM %s',probname))

probnamel = sprintf('%s_meth1_',probname);

[nnonlin,thetan,topf] = count(thetanonlin,wantplotf,probnamel);
disp('The fsolve truss solutions')
thetanonlin'
disp('The unique fsolve   truss solutions')
thetan'

[nhomoto,thetah,toph] = count(thetahomotop,wantploth,probnamel);
disp('The homotopy truss solutions')
thetahomotop'
disp('The unique homotopy truss solutions')
thetah'

disp(sprintf('%d unique truss solutions from fsolve ',nnonlin))
disp(sprintf('%d unique truss solutions from homotop',nhomoto))

disp('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')

myff{karun}{1} = topf;
myhh{karun}{1} = toph;
myfangles{karun}{1} = thetan;
myhangles{karun}{1} = thetah;



