

function [thetanonlin,thetahomotop] = methodpoly(probname,karun,wantplotf,wantploth)

global myl_vert myl_bott myl_top mylambda mythetatrue myscale myff myhh myfangles myhangles


% Solves the Watson truss problem using Fsolve, comparing
% with a polynomial homotopy method.

% Generate the data for the easy function.

mythetatrue = (pi/2)*rand(3,1); %gives 10 and 8 or 12 and 8
myscale = myl_top';

options = optimset('Display','off','TolX',1.e-3,'TolFun',1.e-3);


% Generate the starting points, the 16 solutions to the easy problem.

mylambda = 0;

choice = [1  3  2
         -1 -3 -2
          2  1  3
         -2 -1 -3]
kmax = 0;
for i=1:4,
for j=1:4,
for k=1:4,
  temp      = [choice(i,1),choice(j,2),choice(k,3)];
  if (norm(homopoly(temp)) < 1.e-2)
      kmax = kmax + 1;
      s(kmax,:) =temp;
   end
end
end
end

start = s';

for k=1:kmax,

% Use fsolve to solve the problem, starting from the kth 
% starting point.

   [tangents,dummy,fsolverept] = fsolve(@fevalpoly,start(:,k),options);
   theta = atan(tangents)*2;
   [F,z,top,bott] = trusscheck(theta,myl_vert,myl_bott,myl_top,0);

   if (z<2)
     disp(sprintf('Fsolve reports %d. The Polynomial Method fsolve truss is wrong; z=%d.',fsolverept,z))
     theta = zeros(3,1);
   else
     disp(sprintf('Fsolve reports %d. The Polynomial Method fsolve truss is fine.',fsolverept))
   end

   thetanonlin(:,k) = theta;

% Use homotopy to solve the problem using the same starting point.

   tangents = start(:,k);
   kstep = 100;

   for j=1:kstep,
      mylambda = j/kstep;
      [tangents,dummy,fsolverept] = fsolve(@homopoly,tangents,options);
   end

   theta = atan(tangents)*2;
   [F,z,top,bott] = trusscheck(theta,myl_vert,myl_bott,myl_top,0);

   if (z < 2)
     disp(sprintf('Fsolve reports %d. The Polynomial Method homotopy truss is wrong; z=%d.',fsolverept,z))
     theta = zeros(3,1);
   else
     disp(sprintf('Fsolve reports %d. The Polynomial Method homotopy truss is fine.',fsolverept))
   end

   thetahomotop(:,k) = theta;

end

% Print a summary.

disp('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')

disp(sprintf('POLYNOMIAL METHOD ARUN TRUSS PROBLEM %s',probname))

probnamel = sprintf('%s_meth3_',probname);

[nnonlin,thetan,topf] = count(thetanonlin, wantplotf,probnamel);
disp('The fsolve truss solutions')
thetanonlin'
disp('The unique fsolve   truss solutions')
thetan'

[nhomoto,thetah,toph] = count(thetahomotop, wantploth,probnamel);
disp('The homotopy truss solutions')
thetahomotop'
disp('The unique homotopy truss solutions')
thetah'

disp(sprintf('%d unique truss solutions from fsolve ',nnonlin))
disp(sprintf('%d unique truss solutions from homotop',nhomoto))

disp('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')

myff{karun}{2} = topf;
myhh{karun}{2} = toph;
myfangles{karun}{2} = thetan;
myhangles{karun}{2} = thetah;

