
function [F,z,Tbott,Ttop] = polytruss(tangents,l_vert,l_bott,l_top,iprint)

% function [F,z,Tbott,Ttop] = polytruss(tangents,l_vert,l_bott,l_top,iprint)
% Evaluates the polynomial for the truss.
%
% Input:  tangents = 3 tangents for the vertical truss planes
%         l_vert = lengths of vertical trusses
%         l_bott = lengths of bottom   trusses
%         l_top  = lengths of top      trusses
%         iprint = print level (passed on to trusscheck)
% Output: F = residuals of polynomial equations 
%         z = -log_10 of the max error in truss length
%              (=30 if error is zero)
%         Tbott: The rows contain the coordinates of the
%                three vertices of the bottom triangle.
%         Ttop : The rows contain the coordinates of the
%                three vertices of the top triangle.
%
% Dianne P. O'Leary 05/2008


% Use trusscheck to evaluate the residuals F for the lengths of the
% top trussses.

theta = 2 * atan(tangents);

[F,z,Tbott,Ttop] = trusscheck(theta,l_vert,l_bott,l_top,iprint);

% Convert F to polynomial form.

F(1) = F(1) * (1+tangents(1)^2)^2 * (1+tangents(2)^2)^2;
F(2) = F(2) * (1+tangents(2)^2)^2 * (1+tangents(3)^2)^2;
F(3) = F(3) * (1+tangents(1)^2)^2 * (1+tangents(3)^2)^2;



