function Q = compute_Q_from_angles(angl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Q = compute_Q_from_angles(angl)
%
% Given the three Euler angles in the vector angl,
% compute a 3x3 orthogonal matrix Q that achieves
% the transformation.
%    yaw:      phi = angl(1),
%    pitch:  theta = angl(2),
%    roll:     psi = angl(3).
%
%  compute_Q_from_angles.m Dianne P. O'Leary   06/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cyaw = cos(angl(1));
syaw = sin(angl(1));

cpitch = cos(angl(2));
spitch = sin(angl(2));

croll = cos(angl(3));
sroll = sin(angl(3));

Qroll = [1 0 0; 0 croll sroll; 0 -sroll croll];
Qpitch = [cpitch 0 -spitch; 0 1 0; spitch 0 cpitch];
Qyaw = [cyaw syaw 0; -syaw cyaw 0; 0 0 1];

Q = Qroll*Qpitch*Qyaw;

