using System;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace UMD.Bederson {
	/// <summary>
	/// This is a simple round button.
	/// </summary>
	public class RoundButton : UserControl {
		private Font font = new Font("Arial", 10);
		private SolidBrush bgndBrush = new SolidBrush(Color.Blue);
		private SolidBrush textBrush = new SolidBrush(Color.Black);
		private Pen pen = new Pen(Color.Black, 4);
		private string text;
		private bool active = false;	// True when button is shown in visually active style

		public RoundButton() {
			SetStyle(ControlStyles.DoubleBuffer, true);
			SetStyle(ControlStyles.UserPaint, true);
			SetStyle(ControlStyles.AllPaintingInWmPaint, true);

			MouseMove += new MouseEventHandler(RoundButton_MouseMove);
		}

		public string ButtonText {
			get { return text; }
			set {
				text = value;
				Invalidate();
			}
		}

		/*** Internal Implementation ***/

		protected override void OnPaint(PaintEventArgs e) {
			Graphics graphics = e.Graphics;

			int penWidth = 4;
			graphics.FillEllipse(bgndBrush, 0, 0, Width, Height);
			graphics.DrawEllipse(pen, (int)penWidth/2, (int)penWidth/2, Width - penWidth, Height - penWidth);
			graphics.DrawString(text, font, textBrush, penWidth, Height / 2 - 10);
		}

		protected override void OnResize(EventArgs e) {
			base.OnResize (e);
			Invalidate();
		}

		private void RoundButton_MouseMove(object sender, MouseEventArgs e) {
			int xctr = Width / 2;
			int yctr = Height / 2;
			int x = e.X;
			int y = e.Y;
			GraphicsPath path = new GraphicsPath();
			path.AddEllipse(0, 0, Width, Height);
			if (path.IsVisible(new Point(e.X, e.Y))) {
				if (!active) {
					active = true;
					pen.Color = Color.White;
					Invalidate();
				}
			} else {
				if (active) {
					active = false;
					pen.Color = Color.Black;
					Invalidate();
				}
			}
		}
	}
}