/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */
#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/announce.c,v 1.3 1992/07/30 19:36:33 hollings Exp $";
#endif

/*
 * $Log: announce.c,v $
 * Revision 1.3  1992/07/30  19:36:33  hollings
 * fixed calling args.
 *
 * Revision 1.2  1992/01/22  20:42:10  hollings
 * fixed bug with getlogin.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pwd.h>
#include <string.h>
#include <unistd.h>

#include "data.h"

char *getuname()
{
    struct passwd *p;

    p = getpwuid(getuid());
    return(p->pw_name);
}


void Announce(name, data)
char *name;
char *data;
{
    int s;
    int leng;
    struct sockaddr_in sin;
    struct data pkt;

    s = socket(AF_INET, SOCK_DGRAM, 0);
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = inet_addr(ENUMERATOR);
    sin.sin_port = htons(PORT);

    /* build pkt */
    pkt.version = htonl(VERSION);
    strncpy(pkt.program, name, MAX_LEN-1);
    gethostname(pkt.hostname, MAX_LEN);
    strncpy(pkt.user, getuname(), MAX_LEN-1);
    strncpy(pkt.user_data, data, MAX_LEN-1);

    leng = sendto(s, (char *) &pkt, sizeof(pkt), 0, (struct sockaddr *)&sin, 
	sizeof(sin));
}
