/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/cache.c,v 1.4 1992/12/17 01:17:20 hollings Exp $";
#endif

/*
 * $Log: cache.c,v $
 * Revision 1.4  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.3  1992/12/16  19:24:33  hollings
 * fixes to compile with gcc.
 *
 * Revision 1.2  1992/11/25  19:34:04  hollings
 * improved error messages.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */


#include <stdio.h>
#include <malloc.h>
#include <memory.h>

#include <X11/Intrinsic.h>
#include "io.h"
#include "cache.h"
#include "map.h"

struct cacheEntry {
    char *command;
    struct serverDataList *data;
    struct cacheEntry *next;
};


struct cacheEntry *dataCache;

/* ARGSUSED */
struct serverDataList *getCacheableData(command)
char *command;
{
    int i;    
    char buf[120];
    struct cacheEntry *entry;
    struct serverDataList *new, *curr;

    for (entry = dataCache; entry; entry = entry->next) {
	if (!strcmp(entry->command, command)) {
	    return(entry->data);
	}
    }

    /*
     * Need to fetch data.
     *
     */
    entry = (struct cacheEntry *) malloc(sizeof(struct cacheEntry));
    entry->next = dataCache;
    dataCache = entry;
    entry->command = (char *) malloc(strlen(command)+1);
    strcpy(entry->command, command);
    entry->data = NULL;

    if (xwin) {
	XDefineCursor(d, xwin, watch);
	XFlush(d);
    }
    requestServerData(command);
    readServerData(buf, sizeof buf);
    if (buf[0] != '1') {
	fprintf(stderr, "%s: %s", buf+2);
	return(NULL);
    }

    curr = NULL;
    while (1) {
	if (getsyms() == EOF) break;
	if (!strcmp(symv[0], ".")) break;
	/* Store result. */
	new = (struct serverDataList *) malloc(sizeof(struct serverDataList));
	memset(new, '\0', sizeof(struct serverDataList));
	if (!curr) {
	    entry->data = new;
	} else {
	    curr->next = new;
	}
	new->next = NULL;
	new->count = symc;
	for (i=0; i < symc; i++) {
	    new->data[i] = (char *) malloc(strlen(symv[i])+1);
	    strcpy(new->data[i], symv[i]);
	}
	curr = new;

	/* Need this as the last bit of data */
    }
    if (strcmp(symv[0], ".")) {
	fprintf(stderr, "Connection Terminated\n");
	exit(0);
    }
    if (xwin) {
	XDefineCursor(d, xwin, crosshair);
	XFlush(d);
    }
    return(entry->data);
}

void purgeCache()
{
    int i;
    struct cacheEntry *tmpCache;
    struct serverDataList *data;
    struct serverDataList *tmpData;

    while (dataCache) {
	/* Free actual data */
	data = dataCache->data;
	while (data) {
	    for (i = 0; i < data->count; i++) {
		free(data->data[i]);
	    }
	    tmpData = data->next;
	    free(data);
	    data = tmpData;
	}
	tmpCache = dataCache->next;
	free(dataCache);
	dataCache = tmpCache;
    }
}
