/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/error.c,v 1.2 1992/12/16 19:24:33 hollings Exp hollings $";
#endif

/*
 * $Log: error.c,v $
 * Revision 1.2  1992/12/16  19:24:33  hollings
 * fixes to compile with gcc.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Text.h>
#include <X11/Shell.h>

#include "windows.h"

extern Widget top;
int ErrorReturn();
extern Pixmap icon_pixmap;

static Arg shell_args[] = {
    { XtNx,		10	},
    { XtNy, 		10 	}, 
};

Arg error_args[20];
static Widget shell = NULL;
static Widget error = NULL;
static Widget label;

static void cont_func(Widget w, int cdata, int rest)
{
    XtUnmapWidget(shell);
    XtRemoveGrab(shell);
    XtDestroyWidget(shell);
    return;
}

static  XtCallbackRec   button_callbacks[] = {
        {(XtCallbackProc) cont_func,    (caddr_t) 0},
        {(XtCallbackProc) 0,    (caddr_t) 0},
};

static Arg             button_args[] = {
    {XtNcallback,   	(XtArgVal) button_callbacks},
    {XtNhorizDistance, 	(XtArgVal) 125 },
    {XtNshapeStyle, 	(XtArgVal) XawShapeOval},
};


Position x, y;
Dimension width;
static Arg		query_args[] = {
    { XtNx,		(XtArgVal) &x },
    { XtNy, 		(XtArgVal) &y },
    { XtNwidth, 	(XtArgVal) &width },
};

void InitError(char *str)
{
    Arg arg[10];
    int count;
    int start_x, start_y;

    XtGetValues(top, query_args, XtNumber(query_args));
    start_x = x + (width - 300) / 2;
    start_y = y + 200;
    XtSetArg(shell_args[0], XtNx, start_x);
    XtSetArg(shell_args[1], XtNy, start_y);

    shell = XtCreatePopupShell("Error Popup",
	overrideShellWidgetClass, top, shell_args, XtNumber(shell_args));

    count = 0;
    XtSetArg(error_args[count], XtNlabel, str);				count++;
    XtSetArg(error_args[count], XtNicon, icon_pixmap);			count++;

    error = XtCreateManagedWidget("Error",
	dialogWidgetClass, shell, error_args, count);

    (void) XtCreateManagedWidget("Continue", commandWidgetClass, error,
	button_args, XtNumber(button_args));

    label = XtNameToWidget(error, "label");
    if (!label) abort();

    XtSetArg(arg[0], XtNresizable, True);
    XtSetArg(arg[1], XtNresize, XawtextResizeWidth);
    XtSetValues(label, arg, 2);

    XtRealizeWidget(shell);
}

int ErrorWindow(char *str)
{
    InitError(str);

    XtAddGrab(shell, TRUE, FALSE);
    XtMapWidget(shell);
    return(0);
}
