
/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/fronts.c,v 1.5 1992/12/17 01:17:20 hollings Exp hollings $";
#endif

/*
 * $Log: fronts.c,v $
 * Revision 1.5  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.4  1992/07/02  19:39:23  hollings
 * Color codeded watch boxes.
 *
 * Revision 1.3  1992/04/24  20:45:46  hollings
 * user preferences.
 *
 * Revision 1.2  1991/12/11  23:02:36  hollings
 * Added support for historic fronts.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */


#include <stdio.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <string.h>

#include "map.h"
#include "cache.h"


#define char u_char
#include "Bitmaps/high.bm"
#include "Bitmaps/low.bm"
#undef char

#define streq !strcmp

extern void ClearPixmap();
#ifdef X_COPYPLANE_BUG
extern void V_XCopyPlane();
#endif

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */

/*
** State machine values.
*/
#define NOTHING		0
#define DOINGHIGHS	1
#define DOINGLOWS	2
#define DOINGCOLD	3
#define DOINGWARM	4
#define DOINGOCFNT	5
#define DOINGSTNRY	6

#define NFRONTTYPES     4

#define FRONT_MAX	100

int lineCount;
struct serverDataList *frontData;


static unsigned char cold_dash[] = { 12, 6 };
#define L_cold_dash 2
static unsigned char warm_dash[] = { 6, 8 };
#define L_warm_dash 2
static unsigned char ocfnt_dash[] = { 12, 6, 6, 6 };
#define L_ocfnt_dash 4
static unsigned char stnry_dash[] = { 3, 3 };
#define L_stnry_dash 2


void drawafront(XPoint vert[], int type, int npoints) 
{
    if (display_depth == 1)
	XSetLineAttributes(d, gc, 5, LineOnOffDash, CapButt, JoinMiter);
    else
	XSetLineAttributes(d, gc, 5, LineSolid, CapButt, JoinMiter);
	
    switch (type) {
	case DOINGCOLD:
	    if (display_depth == 1)
		XSetDashes(d, gc, 0, cold_dash, L_cold_dash);
	    else
		XSetForeground(d, gc, pref.pix[CF]);
	    break;

	case DOINGWARM:
	    if (display_depth == 1)
		XSetDashes(d, gc, 0, warm_dash, L_warm_dash);
	    else
		XSetForeground(d, gc, pref.pix[WF]);
	    break;

	case DOINGOCFNT:
	    if (display_depth == 1)
		XSetDashes(d, gc, 0, ocfnt_dash, L_ocfnt_dash);
	    else
		XSetForeground(d, gc, pref.pix[OF]);
	    break;

	case DOINGSTNRY:
	    if (display_depth == 1)
		XSetDashes(d, gc, 0, stnry_dash, L_stnry_dash);
	    else
		XSetForeground(d, gc, pref.pix[SF]);
	    break;
	}
    
    if (npoints) {
	/* brain damaged Xserver from DEC can't handle 0 point line draws */
	XDrawLines(d, w, gc, vert, npoints, CoordModeOrigin);
    }
    if (npoints > FRONT_MAX) printf("Line too LONG!\n");
}

void draw_fronts() 
{
    extern double center_lon;
    char request[80];
    char *buf, *gettoken();
    XPoint xy[FRONT_MAX];
    Pixmap high, low;
    float rho, ang;
    float lat, lon;
    int i, state, mod;
    int value;
    short x, y;

    /*
    ** Request the front data from the server.
    */
    sprintf(request, "FR %s\n", picturetime);
    lineCount = -1;
    frontData = getCacheableData(request);
    if (!frontData && !pref.epochTime) {
	/* server know front data by old name */
	sprintf(request, "PROD ASUS1-KWBC\n");
	lineCount = -1;
	frontData = getCacheableData(request);
    }

    if (!frontData) {
	XtWarning("Front Data Missing");
	return;
    }
    
    high = XCreateBitmapFromData(d, w, high_bits, high_width, high_height);
    low = XCreateBitmapFromData(d, w, low_bits, low_width, low_height);

    i = 0;
    state = NOTHING;
    while (1) {
	buf = gettoken();
	if (buf == NULL) break;

top:
	switch (state) {

	    case NOTHING:
		if (streq(buf, "HIGHS")) state = DOINGHIGHS;
		else if (streq(buf, "LOWS"))  state = DOINGLOWS;
		else if (streq(buf, "COLD"))  state = DOINGCOLD;
		else if (streq(buf, "WARM"))  state = DOINGWARM;
		else if (streq(buf, "OCFNT")) state = DOINGOCFNT;
		else if (streq(buf, "STNRY")) state = DOINGSTNRY;
		break;

	    case DOINGHIGHS:
	    case DOINGLOWS:
		if ((value = atoi(buf)) == 0) {
		    state = NOTHING;
		    goto top;
		    }
		if (value < 1200) break;   /* Must be pressure value, not loc */
		mod = value > 9999? 1000:100;
		lat = (float) (value / mod); lon = (float) (value % mod);
		rho = 1.866 * a * tan((90-lat)*drc/2);
		ang = (center_lon - lon) * drc;
		x = (short)
		    ((rho * sin(ang) - mapleft)*xwa.width/(mapright-mapleft));
		y = (short)
		    ((-rho * cos(ang) - maptop)*xwa.height/(mapbottom-maptop));
		if (state == DOINGHIGHS) {
		    XSetForeground(d, copygc1, pref.pix[CF]);
#ifdef X_COPYPLANE_BUG
		    if (on_root) {
                        V_XCopyPlane(d, high, w, copygc0, 0, 0,
                        high_width, high_height, x - high_width / 2,
                        V_XCopyPlane(d, high, w, copygc1, 0, 0,
                        high_width, high_height, x - high_width / 2,
                        y - high_height / 2, 1);
		    } else {
#endif
		    XCopyPlane(d, high, w, copygc0, 0, 0, high_width,
		      high_height, x - high_width / 2, y - high_height / 2, 1);
		    XCopyPlane(d, high, w, copygc1, 0, 0, high_width,
		      high_height, x - high_width / 2, y - high_height / 2, 1);
		    }
		else {
		    XSetForeground(d, copygc1, pref.pix[OF]);
                    XCopyPlane(d, low, w, copygc0, 0, 0, low_width, low_height,
                        x - low_width / 2, y - low_height / 2, 1);
                    XCopyPlane(d, low, w, copygc1, 0, 0, low_width, low_height,
                        x - low_width / 2, y - low_height / 2, 1);
		}
		break;



	    case DOINGCOLD: case DOINGWARM:
	    case DOINGOCFNT: case DOINGSTNRY:
		if (oneof(buf, "WK/MDT/STNG/STG/")) break;
		if ((value = atoi(buf)) == 0) {
		    if (i>FRONT_MAX-1) printf("front too long\n");
		    drawafront(xy, state, i);
		    i = 0;
		    state = NOTHING;
		    goto top;
		    }

		mod = value > 9999? 1000:100;
		lat = (float) (value / mod); lon = (float) (value % mod);
		rho = 1.866 * a * tan((90-lat)*drc/2);
		ang = (center_lon - lon) * drc;
	        xy[i].x = (short)
		    ((rho * sin(ang) - mapleft)*xwa.width/(mapright-mapleft));
	        xy[i].y = (short)
		    ((-rho * cos(ang) - maptop)*xwa.height/(mapbottom-maptop));
		i++;
		if (i == FRONT_MAX) {
		    printf("front too long\n");
		    drawafront(xy, state, i);
		    i = 0;
		}
		break;
	    }
	}

    XFreePixmap(d, low);
    XFreePixmap(d, high);
    XSetLineAttributes(d, gc, 0, LineSolid, CapButt, JoinMiter);
}


struct serverDataList *f;


char *gettoken() 
{
    if (!frontData) return(NULL);
    lineCount++;
    if (lineCount == frontData->count) {
	lineCount = 0;
	frontData = frontData->next;
    }
    if (!frontData) return(NULL);
    return(frontData->data[lineCount]);
}





struct { char *fl_name; int fl_sym; } fl[] = {
    { "Cold", DOINGCOLD },
    { "Warm", DOINGWARM },
    { "Stationary", DOINGSTNRY },
    { "Occluded", DOINGOCFNT },
    };

#define LEGLEN 70

void draw_front_legend(char *bot) 
{
    int i, x, y, maxwid = 0;
    XCharStruct cs;
    XFontStruct *f = pref.font[SUBTITLEFONT];
    int sl, dr, fa, fd;
    char *s;

    for (i = 0; i < 3; i++) {
	sl = strlen(fl[i].fl_name);
	XTextExtents(f, fl[i].fl_name, sl, &dr, &fa, &fd, &cs);
	if (cs.width > maxwid) maxwid = cs.width;
	}

    x = 2, y = *bot - NFRONTTYPES * (2 + f->ascent + f->descent);
    ClearPixmap(d, w, gc, x, y, maxwid + 5 + LEGLEN,
	NFRONTTYPES * (2 + f->ascent + f->descent));

    for (i = 0, y = *bot; i < NFRONTTYPES; i++) {
	XPoint v[3];
	sl = strlen(fl[i].fl_name);
	XSetForeground(d, gc, pref.pix[DATA]);
	XDrawImageString(d, w, gc, LEGLEN + 7, y - f->descent,
	    fl[i].fl_name, sl);
	v[0].y = y - (f->descent + f->ascent) / 2;
	v[1].y = v[0].y;
	v[2].y = v[0].y;
	v[0].x = 2;
	v[1].x = 2 + LEGLEN/2;
	v[2].x = 2 + LEGLEN;
	drawafront(v, fl[i].fl_sym, 3);
	y -= f->ascent + f->descent + 2;
	}

    s = "Front Legend"; sl = strlen(s);
    y -= f->descent;
    XSetForeground(d, gc, pref.pix[DATA]);
    XTextExtents(f, s, sl, &dr, &fa, &fd, &cs);
    XDrawImageString(d,w, gc, 2 + (LEGLEN+5+maxwid)/2 - cs.width / 2, y,
	s, sl);

    *bot = y - f->ascent - 10;
    }
