/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/io.c,v 1.2 1992/12/17 01:17:20 hollings Exp $";
#endif

/*
 * $Log: io.c,v $
 * Revision 1.2  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>

#include <X11/Intrinsic.h>

#include "io.h"
#include "map.h"

extern FILE *netin, *netout;
static char request[80];

/*
 * This routine is the Avis of fgets (It tries harder).
 *   This is mostly to catch server timeouts, and then reconnect.
 *
 */
int readServerData(char *buf, int limit)
{
    int ret;

    ret = (int) fgets(buf, limit, netin);
    if (strlen(buf) == limit-1) {
	printf("string overflow\n");
	exit(-1);
    }
    if (buf[0] == '1') return(ret);

    /* fix this */
    if (!strncmp(&buf[2], "Idle too long", 13)) {
	/* try to re-connect */
	(void) fclose(netin);
	(void) fclose(netout);
	connectToServer();
	requestServerData(request);
	readServerData(buf, limit);
    }
    return(ret);
}

void requestServerData(char *buf)
{
    strcpy(request, buf);
    fprintf(netout, buf);
    fflush(netout);
}

/*
** Command line parsing globals.
*/
int symc;
#define MAX_SYMC 600
char *symv[MAX_SYMC];
char cmdbuf[512];

int getsyms() 
{
    int l;
    char *p;

    if (!readServerData(cmdbuf, sizeof cmdbuf)) return EOF;
#ifdef notdef
    l = strlen(cmdbuf);
    while (strchr("\r\n ", cmdbuf[--l])) ;
#else
    for (l= strlen(cmdbuf) - 1; ((cmdbuf[l] == '\r') || 
				(cmdbuf[l] == '\n') || 
				(cmdbuf[l] == ' ')); l--);
#endif
    cmdbuf[++l] = '\0';
    p = cmdbuf;
    symc = 0;
    symv[symc] = p;
    while (parmscan(&p)) {
	if (symc == MAX_SYMC-1) {
	    printf("symv overflow\n");
	    exit(-1);
	}
	symv[++symc] = p;
    }
    symv[++symc] = 0;
    return symc;
}

void connectToServer()
{
    int sock;
    char buf[80];
    extern char *sys_errlist[];
    struct sockaddr_in server;
    struct hostent *hp, *gethostbyname();

    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	putchar('\n');
	perror("socket");
	exit(1);
    }
    server.sin_family = AF_INET;
    server.sin_port = htons(pref.serverPort);
    if ((hp = gethostbyname(pref.serverHost)) == NULL) {
	fprintf(stderr, "\n%s: Host unknown.\n", pref.serverHost);
	exit(1);
    }
    memcpy(&server.sin_addr.s_addr, hp->h_addr, hp->h_length);
    if (connect(sock, (struct sockaddr *) &server, sizeof server) < 0) {
	putchar('\n');
	printf("unable to connect to server %s: %s\n", pref.serverHost,
	    sys_errlist[errno]);
	exit(1);
    }
    netin = fdopen(sock, "r");
    if (!netin) {
	perror("fdopen");
	exit(-1);
    }
    netout = fdopen(sock, "w");
    if (!netout) {
	perror("fdopen");
	exit(-1);
    }
    setbuf(netout, NULL);

    /*
    ** Verify that the server is there and happy.
    */
    readServerData(buf, sizeof buf);
    if (buf[0] != '1') {
	fprintf(stderr, "\n!!! Server failed: %s", buf+2);
	exit(1);
    }
}

