#include <X11/Intrinsic.h>
#include "sadecode.h"
#include "map.h"
#include "io.h"
#include "cache.h"

#define streq !strcmp

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */
    
static int isocolors[] = { ISOPLET, ISOPLE2, ISOPLE3 };

static char *isodash[] = {
    "\004\004",
    "\010\002",
    "\010\001\003\001",
    };

void draw_iso(char *s, short n, char *package) 
{
    extern double center_lon;
    char buf[120];
    XPoint p[500];
    float rho, ang;
    float lat, lon;
    int i;
    bool inbounds;
    int inbound_index;
    struct serverDataList *isoData;

    /*
    ** Request the isobar data from the server.
    */

    sprintf(buf, "%s %s\n", s, package);
    isoData = getCacheableData(buf, "*** Isometric data not available");

    XSetFont(d, gc, pref.font[LILRADARFONT]->fid);

    XSetForeground(d, gc, pref.pix[isocolors[n]]);
    if (n > 0 && pref.pix[isocolors[n-1]] == pref.pix[isocolors[n]]) {
	XSetLineAttributes(d, gc, 1, LineOnOffDash, CapButt, JoinMiter);
	XSetDashes(d, gc, 0, isodash[n-1], strlen(isodash[n-1]));
	}

    i = 0;
    inbounds = FALSE;
    inbound_index = 0;
    for (; isoData; isoData = isoData->next) {
	symc = isoData->count;
	memcpy(symv, isoData->data, sizeof(isoData->data));

	if (symc != 4) continue;
	lat = atof(symv[2]); lon = atof(symv[3]);
	    rho = 1.866*a*tan((90.-lat)*drc/2.);
	    ang = (center_lon - lon) * drc;
	    p[i].x = (short)
		((rho*sin(ang)-mapleft)*xwa.width/(mapright-mapleft));
	    p[i].y = (short)
		((-rho*cos(ang)-maptop)*xwa.height/(mapbottom-maptop));
	if (symv[0][0] == '1') {      /* if not done */
	    if (p[i].x > 0 && p[i].y > 0 && p[i].x < xwa.width &&
		p[i].y < xwa.height) {
		inbounds = TRUE;
		inbound_index = i;
		}
	    i++;
	    }
	else {
	    if (i > 0 && inbounds) {
		i++;
		if (symv[0][0] == '2') {   /* if closed contour */
		    p[i].x = p[0].x;
		    p[i].y = p[0].y;
		    i++;
		    }
		XDrawLines(d,w,gc, p, i, CoordModeOrigin);
		if (!(pref.disp_list[SHO_NOLEGEND]))
		    centered_text(pref.font[LILRADARFONT], symv[1],
			p[inbound_index].x, p[inbound_index].y, FALSE);
		inbounds = FALSE;
		inbound_index = 0;
		}
	    i = 0;
	    }
    }

    /* Clean up--if we were reading from the network (and thus
    ** writing to a file), close the file and rename it to a name
    ** such that we can find it next time.
    */
    XSetLineAttributes(d, gc, 0, LineSolid, CapButt, JoinMiter);
}
