/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
 */

/*
 * $Log: map.h,v $
 * Revision 1.7  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.6  1992/07/02  19:39:23  hollings
 * Color codeded watch boxes.
 *
 * Revision 1.5  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.4  1992/04/24  20:45:46  hollings
 * user preferences.
 *
 * Revision 1.3  1992/01/22  20:43:00  hollings
 * made location of man page a resource.
 *
 * Revision 1.2  1991/12/13  00:31:03  hollings
 * Made LIBDIR a resource.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <sys/file.h>
#include <time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <ctype.h>
#include <assert.h>
#include <netinet/in.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define WXMAPVERSION 1

typedef char bool;
#define TRUE 1
#define FALSE 0

extern XWindowAttributes xwa;
extern GC gc, copygc0, copygc1;

extern Cursor crosshair, watch;
extern Display *d;
extern Window rw, xwin;
#ifdef Wtest
extern Window w;
#else
extern Pixmap w;
#endif

/*
** Font information.
*/
#define IDFONT       0
#define DATAFONT     1
#define TITLEFONT    2
#define WATCHBOXFONT 3
#define SUBTITLEFONT 4
#define BIGRADARFONT 5
#define LILRADARFONT 6
#define MAXFONTS     7

#define FALLBACKFONTNAME "fixed"


/*
** Color information.
*/
#define BG	0
#define MAP	1
#define DATA	2
#define DIMDATA	3
#define REGION	4
/* #define WW	5 - split into TOR_W, SVR_W */
#define VIP1	6
#define VIP2	7
#define VIP3	8
#define VIP4	9
#define VIP5	10
#define VIP6	11
#define WF	12
#define CF	13
#define SF	14
#define OF	15
#define BORDER	16
#define ISOPLET	17
#define ISOPLE2	18
#define ISOPLE3	19
#define TOR_W	20
#define SVR_W 	21
#define MAXCOLORS 22

extern int display_depth;
extern int on_root;


/*
** Array to hold the SA database.
*/
extern char title[];			/* Title string from database */
extern char *note[];			/* Notes to draw on map legend */
extern int nnotes;
extern struct report rr[];		/* Array of reports for all stations */
extern int nrr;				/* Number of reports in database */

/*
** The connection to the server.
*/
extern char picturetime[];
extern char upperairtime[];
extern FILE *netin, *netout;


/*
** Map display options.
*/
#define SHO_NOLEGEND	1
#define SHO_CLD		2
#define SHO_TEMP	3
#define SHO_DEWP	4
#define SHO_PRES	5
#define SHO_WIND	6
#define SHO_WX		7
#define SHO_VIS		8
#define SHO_NAME	9
#define SHO_REGION	10
#define SHO_WATCH	11
#define SHO_RADSUM	12
#define SHO_ARS		13
#define SHO_FRONT	14
#define SHO_ISOBAR	15
#define SHO_ISOTHERM	16
#define SHO_ISODROSO	17
#define SHO_SELS	18
#define SHO_NOSUBTTL	19
#define NR_OPTIONS	20


extern double scale,                   /* Map scale factor */
       center_lon, center_lat;  /* Coordinates of center of map */
/* Maximum WMO station priority to display */
extern int maxprio;                    


struct preference {
    int		rawConditions;		/* disp. raw format of current cond. */
    int		showLegend;		/* disp. fonts/echo ledgend */
    int		gmtTime;		/* show time in gmt not local */
    int		metric;			/* show values in metric units */
    char 	*serverHost;		/* name of server */
    int 	serverPort;		/* port to connect to server on */
    char 	*libDirectory;		/* dir. with city/station data in it */
    int		autoRescan;		/* get new data from the server */
    bool 	monochrome;		/* force monochrome disp. */
    bool 	forcecolor;		/* force color disp. */
    bool 	reverse;		/* use reverse video (swap fg/bg) */
    XFontStruct *font[MAXFONTS];	/* fonts to use */
    Pixel	pix[MAXCOLORS];		/* pixel of colors to use */
    char	disp_list[NR_OPTIONS];	/* display list */
    char	*geometry;		/* requested geometry */
    char	*epochTime;		/* start at past time */
    char 	*helpFile;		/* where is the man page */
    int		height;			/* 0, 200, 300, 500, 700, 850 */
};

typedef struct preference *pPtr;
extern struct preference pref;

/*
 * Various regions of the country.
 *
 */
#define REGION_AT 1
#define REGION_MW 2
#define REGION_NE 3
#define REGION_NW 4
#define REGION_SE 5
#define REGION_SP 6
#define REGION_SW 7

/*
 * A point on the earth.
 *
 */
struct locs {
    float lat;
    float lon;
};

