/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/mapdraw.c,v 1.6 1992/12/17 01:17:20 hollings Exp hollings $";
#endif

/*
 * $Log: mapdraw.c,v $
 * Revision 1.6  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.5  1992/11/25  19:34:21  hollings
 * fixed a return code.
 *
 * Revision 1.4  1992/07/02  19:39:23  hollings
 * Color codeded watch boxes.
 *
 * Revision 1.3  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.2  1992/04/24  20:45:46  hollings
 * user preferences.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/List.h>
#include <X11/cursorfont.h>
#include "sadecode.h"
#include "map.h"
#include "windows.h"
#include "us.h"

#ifdef X_COPYPLANE_BUG
extern void V_XCopyPlane();
#endif

extern Widget top;

#define char u_char
#include "Bitmaps/BKN.bm"
#include "Bitmaps/BS.bm"
#include "Bitmaps/CLR.bm"
#include "Bitmaps/F.bm"
#include "Bitmaps/H.bm"
#include "Bitmaps/IP.bm"
#include "Bitmaps/K.bm"
#include "Bitmaps/L.bm"
#include "Bitmaps/Lm.bm"
#include "Bitmaps/Lp.bm"
#include "Bitmaps/MSG.bm"
#include "Bitmaps/OVC.bm"
#include "Bitmaps/R.bm"
#include "Bitmaps/RW.bm"
#include "Bitmaps/RWm.bm"
#include "Bitmaps/Rm.bm"
#include "Bitmaps/Rp.bm"
#include "Bitmaps/S.bm"
#include "Bitmaps/SCT.bm"
#include "Bitmaps/SG.bm"
#include "Bitmaps/SW.bm"
#include "Bitmaps/SWm.bm"
#include "Bitmaps/Sm.bm"
#include "Bitmaps/Sp.bm"
#include "Bitmaps/T.bm"
#include "Bitmaps/TRW.bm"
#include "Bitmaps/TRWp.bm"
#include "Bitmaps/X.bm"
#include "Bitmaps/ZL.bm"
#include "Bitmaps/ZLm.bm"
#include "Bitmaps/ZR.bm"
#include "Bitmaps/ZRm.bm"
#include "Bitmaps/gray1.bm"
#include "Bitmaps/gray2.bm"
#include "Bitmaps/gray3.bm"
#include "Bitmaps/gray4.bm"
#include "Bitmaps/gray5.bm"
#include "Bitmaps/gray6.bm"
#include "Bitmaps/gray7.bm"
#include "Bitmaps/gray8.bm"
#include "Bitmaps/gray9.bm"
#include "Bitmaps/hatch.bm"

#undef char

void ClearPixmap();


short vip[6];


Pixmap BKN_symb, BS_symb, CLR_symb, F_symb, H_symb, IP_symb,
    K_symb, L_symb, Lm_symb, Lp_symb, MSG_symb, OVC_symb, R_symb,
    RW_symb, RWm_symb, Rm_symb, Rp_symb, S_symb, SCT_symb, SG_symb,
    SW_symb, SWm_symb, Sm_symb, Sp_symb, T_symb, TRW_symb, TRWp_symb,
    X_symb, ZL_symb, ZLm_symb, ZR_symb, ZRm_symb;

Pixmap gray1, gray2, gray3, gray4, gray5, gray6, gray7, gray8, gray9, hatch;

double pi = 3.1415927,		/* The value of pi */
      rdc = 57.29578,		/* Degrees to radians conversion */
      drc = 0.0174533,		/* Radians to degrees conversion */
      a = 63.71,		/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom,	/* Extents of domain in the y direction */
      radc;					/* radius at center of map */
    

Widget init_x() 
{
    int i;
    Window w;
    XColor def;
    Visual *vis;
    Colormap cmap;
    Widget opendisplay();

    Announce("wxmap2", "???");

    top = opendisplay();
    if (d == NULL) {
	printf("*** Couldn't open display; MAP command not available.\n");
	return(NULL);
    }
    getdefaults();

    w = RootWindow(d, DefaultScreen(d));
    printf("Loading from X display... ");
    fflush(stdout);

    vip[0] = VIP1; vip[1] = VIP2; vip[2] = VIP3;
    vip[3] = VIP4; vip[4] = VIP5; vip[5] = VIP6;
    if (pref.monochrome) {
	display_depth = 1;
    } else {
	int colorDisplay;
	colorDisplay = (XDisplayCells(d, DefaultScreen(d)) > 2);
	display_depth = colorDisplay ? 2 : 1;
    }
	
    
    BKN_symb = XCreateBitmapFromData(d,w, BKN_bits, BKN_width, BKN_height);
    BS_symb = XCreateBitmapFromData(d,w, BS_bits, BS_width, BS_height);
    CLR_symb = XCreateBitmapFromData(d,w, CLR_bits, CLR_width, CLR_height);
    F_symb = XCreateBitmapFromData(d,w, F_bits, F_width, F_height);
    H_symb = XCreateBitmapFromData(d,w, H_bits, H_width, H_height);
    IP_symb = XCreateBitmapFromData(d,w, IP_bits, IP_width, IP_height);
    K_symb = XCreateBitmapFromData(d,w, K_bits, K_width, K_height);
    L_symb = XCreateBitmapFromData(d,w, L_bits, L_width, L_height);
    Lm_symb = XCreateBitmapFromData(d,w, Lm_bits, Lm_width, Lm_height);
    Lp_symb = XCreateBitmapFromData(d,w, Lp_bits, Lp_width, Lp_height);
    MSG_symb = XCreateBitmapFromData(d,w, MSG_bits, MSG_width, MSG_height);
    OVC_symb = XCreateBitmapFromData(d,w, OVC_bits, OVC_width, OVC_height);
    R_symb = XCreateBitmapFromData(d,w, R_bits, R_width, R_height);
    RW_symb = XCreateBitmapFromData(d,w, RW_bits, RW_width, RW_height);
    RWm_symb = XCreateBitmapFromData(d,w, RWm_bits, RWm_width, RWm_height);
    Rm_symb = XCreateBitmapFromData(d,w, Rm_bits, Rm_width, Rm_height);
    Rp_symb = XCreateBitmapFromData(d,w, Rp_bits, Rp_width, Rp_height);
    S_symb = XCreateBitmapFromData(d,w, S_bits, S_width, S_height);
    SCT_symb = XCreateBitmapFromData(d,w, SCT_bits, SCT_width, SCT_height);
    SG_symb = XCreateBitmapFromData(d,w, SG_bits, SG_width, SG_height);
    SW_symb = XCreateBitmapFromData(d,w, SW_bits, SW_width, SW_height);
    SWm_symb = XCreateBitmapFromData(d,w, SWm_bits, SWm_width, SWm_height);
    Sm_symb = XCreateBitmapFromData(d,w, Sm_bits, Sm_width, Sm_height);
    Sp_symb = XCreateBitmapFromData(d,w, Sp_bits, Sp_width, Sp_height);
    T_symb = XCreateBitmapFromData(d,w, T_bits, T_width, T_height);
    TRW_symb = XCreateBitmapFromData(d,w, TRW_bits, TRW_width, TRW_height);
    TRWp_symb = XCreateBitmapFromData(d,w, TRWp_bits, TRWp_width, TRWp_height);
    X_symb = XCreateBitmapFromData(d,w, X_bits, X_width, X_height);
    ZL_symb = XCreateBitmapFromData(d,w, ZL_bits, ZL_width, ZL_height);
    ZLm_symb = XCreateBitmapFromData(d,w, ZLm_bits, ZLm_width, ZLm_height);
    ZR_symb = XCreateBitmapFromData(d,w, ZR_bits, ZR_width, ZR_height);
    ZRm_symb = XCreateBitmapFromData(d,w, ZRm_bits, ZRm_width, ZRm_height);

    gray1 = XCreateBitmapFromData(d, w, gray1_bits, gray1_width, gray1_height);
    gray2 = XCreateBitmapFromData(d, w, gray2_bits, gray2_width, gray2_height);
    gray3 = XCreateBitmapFromData(d, w, gray3_bits, gray3_width, gray3_height);
    gray4 = XCreateBitmapFromData(d, w, gray4_bits, gray4_width, gray4_height);
    gray5 = XCreateBitmapFromData(d, w, gray5_bits, gray5_width, gray5_height);
    gray6 = XCreateBitmapFromData(d, w, gray6_bits, gray6_width, gray6_height);
    gray7 = XCreateBitmapFromData(d, w, gray7_bits, gray7_width, gray7_height);
    gray8 = XCreateBitmapFromData(d, w, gray8_bits, gray8_width, gray8_height);
    gray9 = XCreateBitmapFromData(d, w, gray9_bits, gray9_width, gray9_height);
    hatch = XCreateBitmapFromData(d, w, hatch_bits, hatch_width, hatch_height);

    return(top);
}

resizePixmap()
{
    XGCValues gc_init;
    GC mygc;
    Pixmap pm = (Pixmap) 0;
    int screen = DefaultScreen(d);

    XDefineCursor(d, xwin, watch);
    if (gc)
	XFreeGC(d, gc);
    if (copygc0)
        XFreeGC(d, copygc0);
    if (copygc1)
        XFreeGC(d, copygc1);
    gc = XCreateGC(d, w, 0, NULL);
    copygc0 = XCreateGC(d, w, 0, NULL);
    copygc1 = XCreateGC(d, w, 0, NULL);

    XSetBackground(d, gc, pref.pix[BG]);
    XSetGraphicsExposures(d, gc, False);
    XSetFillStyle(d, gc, FillSolid);

    XCopyGC(d, gc, ~0, copygc0);
    XSetFunction(d, copygc0, GXandInverted);
    XSetBackground(d, copygc0, 0);
    XSetForeground(d, copygc0, ~0);

    XCopyGC(d, copygc0, ~0, copygc1);
    XSetFunction(d, copygc1, GXor);

    XClearWindow(d, xwin);
    draw_data();
    XDefineCursor(d, xwin, crosshair);
    XSync(d, False);
}

centered_text(f, s, x,y, image) XFontStruct *f; char *s; int x,y; char image; {
    XCharStruct cs;
    int sl, dr, fa, fd;

    sl = strlen(s);
    XSetFont(d, gc, f->fid);
    XTextExtents(f, s, sl, &dr, &fa, &fd, &cs);
    if (image)
	XDrawImageString(d, w, gc, x-cs.width/2, y+(cs.ascent+cs.descent)/2,
	    s, sl);
    else
	XDrawString(d, w, gc, x-cs.width/2, y+(cs.ascent+cs.descent)/2, s, sl);
    }





draw_data() 
{
    char buf[10];
    extern double center_lat, center_lon;
    extern int maxprio;
    float rho, ang;
    short x, y;
    struct report *r = rr;
    int ii = 0;
    int i;

    scale_us();

    draw_region(SHO_REGION);

    draw_mdr();

    if (pref.height == 0) {
	if (pref.disp_list[SHO_ISOBAR]) draw_iso("IB", ii++, picturetime);
	if (pref.disp_list[SHO_ISOTHERM]) draw_iso("IT", ii++, picturetime);
	if (pref.disp_list[SHO_ISODROSO]) draw_iso("ID", ii++, picturetime);
    } else {
	/* upper air data */
	if (pref.disp_list[SHO_ISOBAR]) {
	    sprintf(buf, "H%d", pref.height);
	    draw_iso(buf, ii++, upperairtime);
	}
	if (pref.disp_list[SHO_ISOTHERM]) {
	    sprintf(buf, "T%d", pref.height);
	    draw_iso(buf, ii++, upperairtime);
	}
    }

    makeTitleLine();
 
    if (pref.disp_list[SHO_FRONT]) draw_fronts();

    draw_us();

    if (pref.height > 0) {
	sprintf(buf, "U%d", pref.height);
	draw_ua(buf);
    } else {
	XSetForeground(d, gc, pref.pix[DATA]);
	for (i = 0; i < nrr; i++, r++) {
	    if (r->prio > maxprio) continue;
	    rho = 1.866*a*tan((90.-r->lat)*drc/2.);
	    ang = (center_lon - r->lon) * drc;
	    x = (short)((rho * sin(ang) - mapleft)*xwa.width/
		(mapright-mapleft));
	    y = (short)((-rho * cos(ang) - maptop)*xwa.height/
		(mapbottom-maptop));
	    if (x < 0 || y < 0 || x > xwa.width || y > xwa.height) continue;
	    if (r->time[0] == 'M') {                    /* Missing report */
		if (pref.disp_list[SHO_NAME])
		    centered_text(pref.font[IDFONT], r->id, x, y, FALSE);
		continue;
		}
	    if (pref.disp_list[SHO_NAME] && !(pref.disp_list[SHO_CLD]))
		centered_text(pref.font[IDFONT], r->id, x, y, FALSE);
	    draw_report(r, x, y);
	    }
    }

    draw_region(SHO_WATCH);

    if (pref.disp_list[SHO_SELS]) draw_sels();

    if (pref.showLegend) draw_legend();
}

draw_legend() 
{
    short offset = xwa.height;  /* bottom of each legend */

    if (pref.disp_list[SHO_ARS] || pref.disp_list[SHO_RADSUM]) 
	draw_mdr_legend(&offset);
    if (pref.disp_list[SHO_FRONT]) draw_front_legend(&offset);

    if (pref.disp_list[SHO_SELS]) draw_sels_legend(&offset);
}

scale_us() {
    extern  double center_lat,  /* Central lat on which projection is based */
	    scale;		/* Distance between grid points */
    extern double   radc;	/* Polar stereographic radius of the center */

/*
** Locate the projection in polar stereographic coordinates
*/
    radc = 1.866 * a * tan((90. - center_lat) * drc / 2.);

/*
** Locate the corners of the grid
*/
    maptop = -radc + 8. * scale;
    mapleft =  -12. * scale;
    mapright = -mapleft;
    mapbottom = -radc - 8. * scale;
    }







draw_us() {
   extern  double center_lon;   /* Central lon on which projection is based */
   float   radc,		/* Polar stereographic radius of the center */
           r, ang;		/* P.s. radius and angle for a given point */
   XPoint  xy[40];              /* The X array of points */
   int     i, m;		/* Loop control variables */
   bool inbounds;		/* True if any point is in the window */


   XSetForeground(d, gc, pref.pix[MAP]);
   for (i = 0; i < regionCount; i++) {
      /*
      ** For each point in the segment, convert the endpoint to
      ** polar stereographic coordinates, then draw the segment.
      */
      inbounds = FALSE;
      for (m=0; m < USA[i].pCount; m++) {
	 r = 1.866 * a * tan((90 - USA[i].point[m].lat) * drc / 2);
	 ang = (center_lon - USA[i].point[m].lon) * drc;
	 xy[m].x = (short)((r * sin(ang) - mapleft)*xwa.width/(mapright-mapleft));
	 xy[m].y = (short)((-r * cos(ang) - maptop)*xwa.height/(mapbottom-maptop));
	 if (xy[m].x > 0 && xy[m].y > 0 && xy[m].x < xwa.width &&
	    xy[m].y < xwa.height) inbounds = TRUE;
         }
      if (inbounds)
	  XDrawLines(d, w, gc, xy, USA[i].pCount, CoordModeOrigin);
      }
   return 0;
   }






static char *cldprio = " sSbBoOxX";

draw_report(r, x, y) struct report *r; short x,y; {
    char *sky = cldprio, *index();
    int i, sl;
    int dr, fa, fd;
    char buf[10];
    XCharStruct cs;
    Pixmap cld_symb;
    short width = 0, height = 0, visoffs = x - 8;


    /*
    ** Draw cloud cover symbol
    */
    XSetFont(d, gc, pref.font[DATAFONT]->fid);
    XSetForeground(d, copygc1, pref.pix[DATA]);

    if (pref.disp_list[SHO_CLD] && r->nlayers != MISSING_I) {
	for (i = 0; i < r->nlayers; i++) {
	    char *s = index(cldprio, r->cover[i]);
	    assert (s != NULL);
	    if (s > sky) sky = s;
	    }
	switch (*sky) {
	    case ' ':
		cld_symb = CLR_symb;
		break;
	    case 's': case 'S':
		cld_symb = SCT_symb;
		break;
	    case 'b': case 'B':
		cld_symb = BKN_symb;
		break;
	    case 'o': case 'O':
		cld_symb = OVC_symb;
		break;
	    case 'x': case 'X':
		cld_symb = X_symb;
		break;
	    default:
		printf("??? Station %s sky '%c'\n", r->id, *sky);
		return;
	    }
#ifdef X_COPYPLANE_BUG
	if (on_root)
	    V_XCopyPlane(d, cld_symb, w, gc, 0,0, CLR_width,CLR_height,
		x-8,y-8, 1);
	else
#endif
	XCopyPlane(d, cld_symb, w, copygc0,0,0,CLR_width,CLR_height,x-5,y-5,1);
	XCopyPlane(d, cld_symb, w, copygc1,0,0,CLR_width,CLR_height,x-5,y-5,1);
	if (*sky != ' ') {
	    if (r->ceiltype != ' ')
		sprintf(buf, "%d", r->height[r->ceillayer]);
	    else
		sprintf(buf, "%d", r->height[0]);
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x-2, y+6+cs.ascent, buf, sl);
	    }
	}
    else if ((pref.disp_list[SHO_TEMP]) && (pref.disp_list[SHO_CLD]) &&
	r->nlayers == MISSING_I) {
	cld_symb = MSG_symb;
#ifdef X_COPYPLANE_BUG
	if (on_root)
	    V_XCopyPlane(d, cld_symb, w, gc, 0,0, MSG_width,MSG_height,
		x-8,y-8, 1);
	else
#endif
	XCopyPlane(d, cld_symb, w, copygc0,0,0,MSG_width,MSG_height,x-5,y-5,1);
	XCopyPlane(d, cld_symb, w, copygc1,0,0,MSG_width,MSG_height,x-5,y-5,1);
	}

    /*
    ** Draw temperature and dewpoint
    */
    if (pref.disp_list[SHO_TEMP] && (r->temp != MISSING_I)) {
	sprintf(buf, "%d", r->temp);
	if (OnlyDisp(SHO_TEMP))
	    centered_text(pref.font[IDFONT], buf, x, y, FALSE);
	else {
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x-4-cs.width, y-6, buf, sl);
	    }
	}
    if (pref.disp_list[SHO_DEWP] && (r->dewpt != MISSING_I)) {
	sprintf(buf, "%d", r->dewpt);
	if (OnlyDisp(SHO_DEWP))
	    centered_text(pref.font[IDFONT], buf, x, y, FALSE);
	else {
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x-4-cs.width, y+6+cs.ascent, buf, sl);
	    }
	}
    
    /*
    ** Draw barometric pressure
    */
    if (pref.disp_list[SHO_PRES] && r->altimeter != MISSING_I) {
	sprintf(buf, "%.2f", r->altimeter);
	buf[0] = buf[1];
	buf[1] = buf[3];
	buf[2] = buf[4];
	buf[3] = '\0';
	if (OnlyDisp(SHO_PRES))
	    centered_text(pref.font[IDFONT], buf, x, y, FALSE);
	else {
	    sl = 3;
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x+3, y-6, buf, sl);
	    }
	}
    
    /*
    ** Draw the WX symbol.
    */
    if (pref.disp_list[SHO_WX] && r->wx[0]) {
	Pixmap curwx;
	char *wxsym = r->wx;

	if (wxsym[0] == 'V') wxsym++;    /* skip over Variable designator */

	if (wxsym[0] == 'K') {
	    width = K_width, height = K_height;
	    curwx = K_symb;
	    }
	else if (wxsym[0] == 'H') {
	    width = H_width, height = H_height;
	    curwx = H_symb;
	    }
	else if (wxsym[0] == 'F') {
	    width = F_width, height = F_height;
	    curwx = F_symb;
	    }
	else if (wxsym[0] == 'T') {
	    if (!strncmp(wxsym, "TRW+", 4)) {
		width = TRWp_width, height = TRWp_height;
		curwx = TRWp_symb;
		}
	    else if (!strncmp(wxsym, "TRW", 3)) {
		width = TRW_width, height = TRW_height;
		curwx = TRW_symb;
		}
	    else {
		width = T_width, height = T_height;
		curwx = T_symb;
		}
	    }
	else if (wxsym[0] == 'R') {
	    if (!strncmp(wxsym, "RW-", 3)) {
		width = RWm_width, height = RWm_height;
		curwx = RWm_symb;
		}
	    else if (wxsym[1] == 'W') {
		width = RW_width, height = RW_height;
		curwx = RW_symb;
		}
	    else if (wxsym[1] == '+') {
		width = Rp_width, height = Rp_height;
		curwx = Rp_symb;
		}
	    else if (wxsym[1] == '-') {
		width = Rm_width, height = Rm_height;
		curwx = Rm_symb;
		}
	    else {
		width = R_width, height = R_height;
		curwx = R_symb;
		}
	    }
	else if (wxsym[0] == 'S') {
	    if (!strncmp(wxsym, "SW-", 3)) {
		width = SWm_width, height = SWm_height;
		curwx = SWm_symb;
		}
	    else if (wxsym[1] == 'W') {
		width = SW_width, height = SW_height;
		curwx = SW_symb;
		}
	    else if (wxsym[1] == '+') {
		width = Sp_width, height = Sp_height;
		curwx = Sp_symb;
		}
	    else if (wxsym[1] == '-') {
		width = Sm_width, height = Sm_height;
		curwx = Sm_symb;
		}
	    else if (wxsym[1] == 'G') {
		width = SG_width, height = SG_height;
		curwx = SG_symb;
		}
	    else {
		width = S_width, height = S_height;
		curwx = S_symb;
		}
	    }
	else if (wxsym[0] == 'L') {
	    if (wxsym[1] == '-') {
		width = Lm_width, height = Lm_height;
		curwx = Lm_symb;
		}
	    else if (wxsym[1] == '+') {
		width = Lp_width, height = Lp_height;
		curwx = Lp_symb;
		}
	    else {
		width = L_width, height = L_height;
		curwx = L_symb;
		}
	    }
	else if (wxsym[0] == 'Z') {
	    if (!strncmp(wxsym, "ZR-", 3)) {
		width = ZRm_width, height = ZRm_height;
		curwx = ZRm_symb;
		}
	    else if (!strncmp(wxsym, "ZL-", 3)) {
		width = ZLm_width, height = ZLm_height;
		curwx = ZLm_symb;
		}
	    else if (wxsym[1] == 'L') {
		width = ZL_width, height = ZL_height;
		curwx = ZLm_symb;
		}
	    else if (wxsym[1] == 'R') {
		width = ZR_width, height = ZR_height;
		curwx = ZR_symb;
		}
	    }
	else if (!strncmp(wxsym, "BS", 2)) {
	    width = BS_width, height = BS_height;
	    curwx = BS_symb;
	    }
	else if (!strncmp(wxsym, "IP", 2)) {
	    width = IP_width, height = IP_height;
	    curwx = IP_symb;
	    }
	
	if (width) {
	    if (OnlyDisp(SHO_WX))
		visoffs = x - width/2;
	    else
		visoffs = x - 8 - width;
	    XCopyPlane(d,curwx,w,copygc0, 0,0, width,height, visoffs,y-7, 1);
	    XCopyPlane(d,curwx,w,copygc1, 0,0, width,height, visoffs,y-7, 1);
	    }
	}

    if ((pref.disp_list[SHO_VIS] || pref.disp_list[SHO_WX]) && 
	r->vis != MISSING_F && r->vis<6.0) {
	sprintf(buf, "%.1g", r->vis);
	if (OnlyDisp(SHO_VIS))
	    centered_text(pref.font[IDFONT], buf, x, y, FALSE);
	else {
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, visoffs-cs.width, y+5, buf, sl);
	    }
	}

    /*
    ** Draw wind barb. Don't forget to skew the vector around so that
    ** north matches north on the map projection, not straight up
    ** on the map. (I should have realized this a long time ago; it's
    ** first-day lecture material in Atmospheric Sciences classes.)
    */
    if (pref.disp_list[SHO_WIND] && r->wdir != MISSING_I)
        draw_wind(r->wdir + (short)(r->lon - center_lon), r->wspd, x, y);
    }




draw_wind(dir, speed, x, y) short dir, speed, x, y; {
    XSegment l[20];
    short li = 0, i;
    short nflag, nfull, nhalf;
    float rdir, cosdir, sindir;
    float fx = (float) x, fy = (float) y;
    float yi;
    
    if (speed == 0) return;

    /*
    ** First determine how many full and half barbs there will be,
    ** and compute the angle of the symbol in radians.
    */
    nflag = speed / 50;
    speed = speed - 50 * nflag;
    nfull = speed / 10;
    nhalf = (speed - 10*nfull) >= 5;
    rdir = (float)dir * drc;
    cosdir = cos(rdir);
    sindir = sin(rdir);

    /*
    ** Build the stem.
    */
    l[li].x1 = x + (short) (5*sindir);
    l[li].y1 = y + (short) (-5.*cosdir);
    l[li].x2 = x + (short) (27.*sindir);
    l[li].y2 = y + (short) (-27.*cosdir);
    li++;

    /*
    ** Build and draw the flags.
    */
    XSetFillStyle(d, gc, FillSolid);
    for (i = 0, yi = 28.; i < nflag; i++, yi -= 5.) {
        XPoint p[4];
        p[0].x = p[3].x = x + (short) (yi*sindir);
        p[0].y = p[3].y = y + (short) (-yi*cosdir);
        p[1].x = x + (short) (12.*cosdir + yi*sindir);
        p[1].y = y + (short) (12.*sindir - yi*cosdir);
        p[2].x = x + (short) ((yi-5.)*sindir);
        p[2].y = y + (short) ((5.-yi)*cosdir);
        XFillPolygon(d, w, gc, p, 4, Convex, CoordModeOrigin);
        }

    /*
    ** Build the full barbs.
    */
    for (i = 0, yi--; i < nfull; i++, yi -= 3.) {
	l[li].x1 = x + (short) (yi*sindir);
	l[li].y1 = y + (short) (-yi*cosdir);
	l[li].x2 = x + (short) (10.*cosdir + (yi+2.)*sindir);
	l[li].y2 = y + (short) (10.*sindir - (yi+2.)*cosdir);
	li++;
	}
    
    /*
    ** Build the (possible) half barb.
    */
    if (nhalf) {
	l[li].x1 = x + (short) (yi*sindir);
	l[li].y1 = y + (short) (-yi*cosdir);
	l[li].x2 = x + (short) (5.*cosdir + (yi+1.)*sindir);
	l[li].y2 = y + (short) (5.*sindir - (yi+1.)*cosdir);
	li++;
	}
    
    /*
    ** DRAW!
    */
    XDrawSegments(d, w, gc, l, li);
    }





void
ClearPixmap(dpy, p, gc, x, y, width, height)
Display *dpy; Pixmap p; GC gc; int x,y; unsigned int width, height; {

    XSetForeground(dpy, gc, pref.pix[BG]);
    XSetFillStyle(dpy, gc, FillSolid);
    XFillRectangle(dpy, p, gc, x, y, width, height);
    }




void
reset_root_window() {
    int screen = DefaultScreen(d);
    Screen *s = XDefaultScreenOfDisplay(d);
    int root_depth;

    /* For window managers like swm and tvtwm, support a virtual root */

    Atom __SWM_VROOT = None;
    Window rootReturn, parentReturn, *children;
    unsigned int numChildren;
    int i;

    /* see if there is a virtual root */

    rw = RootWindow(d, screen);
    __SWM_VROOT = XInternAtom(d, "__SWM_VROOT", False);
    XQueryTree(d, rw, &rootReturn, &parentReturn, &children, &numChildren);
    for (i = 0; i < numChildren; i++) {
	Atom actual_type;
	int actual_format;
	unsigned long nitems, bytesafter;
	Window *newRoot = NULL;

	if (XGetWindowProperty (d, children[i], __SWM_VROOT,0,1,
	    False, XA_WINDOW, &actual_type, &actual_format,
	    &nitems, &bytesafter, (unsigned char **) &newRoot) ==
	    Success && newRoot) {
		rw = *newRoot;
		break;
	    }
    }

    root_depth = DefaultDepth(d,screen);

    /* reset root window to default condition */

    XUndefineCursor(d, rw);
    if (rw == RootWindow(d, screen)) {
	XSetWindowBackgroundPixmap(d, rw, (Pixmap)None);
	XClearWindow(d, rw);
    } else {
	Pixmap pm = (Pixmap) 0;
	XGCValues gc_init;

	gc_init.foreground = BlackPixel(d, screen);
	gc = XCreateGC(d, rw, GCForeground, &gc_init);
	pm = XCreatePixmap(d, rw, 1, 1, root_depth);
	if (pm == NULL) {
	    fprintf(stderr, "!!! Couldn't Create Pixmap.\n");
	    exit(1);
	}
	XDrawPoint(d, pm, gc, 0, 0);
	XSetWindowBackgroundPixmap(d, rw, pm);
	XClearWindow(d, rw);
	XFreeGC(d, gc);
	XFreePixmap(d, pm);
	gc = (GC) 0;
    }
    XSync(d, False);
}

void
set_up_root_window() {
    int root_height, root_width, root_depth;
    int screen = DefaultScreen(d);

    reset_root_window();

    root_depth = DefaultDepth(d,screen);
    root_height = DisplayHeight(d,screen);
    root_width = DisplayWidth(d,screen);

    w = XCreatePixmap(d,rw,root_width,root_height,root_depth);
    if (w == NULL) {
	fprintf(stderr, "!!! Couldn't Create Pixmap.\n");
	exit(1);
    }
    gc = XCreateGC(d, w, 0, NULL);
    XSetGraphicsExposures(d, gc, False);
    ClearPixmap(d, w, gc, 0, 0, root_width, root_height);
    XSetBackground(d, gc, pref.pix[BG]);
    XSetFillStyle(d, gc, FillSolid);
    XGetWindowAttributes(d, rw, &xwa);

    /* Only draw map size of display, NOT the size of the entire virtual root */

    if (xwa.width > root_width)
	xwa.width = root_width;
    if (xwa.height > root_height)
	xwa.height = root_height;
}





void
write_root_window() {
    XSetWindowBackgroundPixmap(d,rw,w);
    XClearWindow(d,rw);
    XFreePixmap(d,w);
    XFreeGC(d, gc);
    XSync(d, False);
    gc = (GC) 0;
    w = (Pixmap) 0;
    }





#ifdef X_COPYPLANE_BUG
void
V_XCopyPlane (dpy,src,dest,gc, src_x,src_y,width,height,dest_x,dest_y,plane)
Display *dpy; Drawable src,dest; GC gc; int src_x,src_y,dest_x,dest_y;
unsigned int width,height; unsigned long plane; {
    Pixmap p = XCreatePixmap(dpy,dest,width,height,root_depth);
    if (p == NULL) {
	fprintf(stderr, "!!! Couldn't Create Pixmap.\n");
	exit(1);
    }
    XCopyPlane(dpy,src,p,gc,src_x,src_y,width,height,0,0,plane);
    XCopyArea(dpy,p,dest,gc,0,0,width,height,dest_x,dest_y);
    XFreePixmap(dpy,p);
    }
#endif

int OnlyDisp(disp)
int disp;
{
    return(!(
     (pref.disp_list[SHO_NAME] && (disp != SHO_NAME)) ||
     (pref.disp_list[SHO_TEMP] && (disp != SHO_TEMP)) ||
     (pref.disp_list[SHO_DEWP] && (disp != SHO_DEWP)) ||
     (pref.disp_list[SHO_PRES] && (disp != SHO_PRES)) ||
     (pref.disp_list[SHO_CLD] && (disp != SHO_CLD)) ||
     (pref.disp_list[SHO_WX] && (disp != SHO_WX)) ||
     (pref.disp_list[SHO_VIS] && (disp != SHO_VIS))));
}
