
/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/mdr.c,v 1.2 1992/12/17 01:17:20 hollings Exp $";
#endif

/*
 * $Log: mdr.c,v $
 * Revision 1.2  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <X11/Intrinsic.h>
#include "sadecode.h"
#include "map.h"
#include "cache.h"
#include "io.h"
#include "radar.h"

#define streq !strcmp

extern void ClearPixmap();

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */


extern Pixmap gray1, gray2, gray4, gray5, gray7, gray9;
static Pixmap g[6];

extern short vip[6];
struct radarObject *radarObjects = NULL;

#define NEW_OBJECT(currObject)				\
    if (!radarObjects) {				\
	radarObjects = (struct radarObject*)		\
	    calloc(sizeof(struct radarObject), 1);	\
	currObject = radarObjects;			\
	currObject->next = NULL;			\
    } else {						\
	currObject->next = (struct radarObject*)	\
	    calloc(sizeof(struct radarObject), 1);	\
	currObject = currObject->next;			\
    }


draw_mdr() 
{
    int limit;
    XPoint *p;
    static int maxPoints;
    struct radarPoint *tempSet;
    struct radarObject *currObject;
    extern double center_lat, center_lon;

    int color;
    float rho, ang;
    float lat, lon;
    int i, j;
    short x, y;
    bool inbounds = FALSE;
    char request[80];
    struct serverDataList *curr;
    struct serverDataList *radarCache;

    if (!(pref.disp_list[SHO_ARS] || pref.disp_list[SHO_RADSUM])) return;

    if (display_depth == 1) {
	XSetFillStyle(d, gc, FillStippled);
	XSetForeground(d, gc, pref.pix[DATA]);
	g[0] = gray1;
	g[1] = gray2;
	g[2] = gray4;
	g[3] = gray5;
	g[4] = gray7;
	g[5] = gray9;
	}
    else
	XSetFillStyle(d, gc, FillSolid);

  if (!radarObjects) {
	/*
	** Request the radar summary data from the server.
	*/
	sprintf(request, "SD %s\n", picturetime);
	radarCache = getCacheableData(request);

	i = 0;
	limit = 16;
	tempSet = (struct radarPoint *)
	    malloc(limit * sizeof(struct radarPoint));
	for (curr = radarCache; curr; curr = curr->next) {
	    symc = curr->count;
	    memcpy(symv, curr->data, sizeof(curr->data));

	    if (strcmp(symv[0], "MDR") == 0) {
		if (symc != 5) continue;
		j = atoi(symv[2]); lat = atof(symv[3]); lon = atof(symv[4]);
		if (j < 1 || j > 6) continue;
		if (symv[1][0] == '1') {      /* if pen down */
		    tempSet[i].lat = lat;
		    tempSet[i].lon = lon;
		    if (display_depth == 1)
			color = g[j-1];
		    else
			color = pref.pix[vip[j-1]];
		    i++;
		    if (i >= limit) {
			limit *= 2;
			tempSet = (struct radarPoint *)
			    realloc(tempSet, limit * sizeof(struct radarPoint));
		    }
		} else {
		    if (i > 0) {
			/* Save object */
			NEW_OBJECT(currObject);
			currObject->type = RADAR_MDR;
			currObject->info.region.count = i;
			currObject->color = color;
			currObject->info.region.data = tempSet;
			if (i > maxPoints) maxPoints = i;
			i = 0;
			limit = 16;
			tempSet = (struct radarPoint *)
			    malloc(limit * sizeof(struct radarPoint));
		    }
		}
	    } else if (strncmp(symv[0], "PPI", 3) == 0) {
		if (symc != 3) continue;
		if (symv[0][3] == 'D') continue;    /* "PPIDE" not plotted */
		NEW_OBJECT(currObject);
		currObject->type = RADAR_PPI;
		currObject->info.ars.location.lat = atof(symv[1]); 
		currObject->info.ars.location.lon = atof(symv[2]);
		currObject->color = pref.pix[DIMDATA];
		strcpy(currObject->info.ars.name, symv[0] + 3);
	    } else if (!strcmp(symv[0], "MT") ||
		     !strcmp(symv[0], "HOOK") ||
		     !strcmp(symv[0], "HAIL")) {
		if (symc != 4) continue;
		NEW_OBJECT(currObject);
		currObject->info.ars.location.lat = atof(symv[2]); 
		currObject->info.ars.location.lon = atof(symv[3]);
		currObject->color = pref.pix[DATA];
		if (!strcmp(symv[0], "MT")) {
		    strcpy(currObject->info.ars.name, symv[1]);
		    currObject->type = RADAR_MT;
		} else {
		    strcpy(currObject->info.ars.name, symv[0]);
		    currObject->type = RADAR_HOOK;
		}
	    } else if (strcmp(symv[0], "MOVE") == 0) {
		if (symc != 5) continue;
		NEW_OBJECT(currObject);
		currObject->type = RADAR_MOVE;
		currObject->info.ars.location.lat = atof(symv[3]); 
		currObject->info.ars.location.lon = atof(symv[4]);
		currObject->info.ars.dir = 10 * atoi(symv[1]); 
		currObject->info.ars.speed = atoi(symv[2]);
	    }
	}
	free(tempSet);
    }

    p = (XPoint *) malloc(sizeof(XPoint) * maxPoints);
    for (currObject = radarObjects; currObject; currObject = currObject->next) {
	if (currObject->type == RADAR_MDR) {
	    for (i=0; i < currObject->info.region.count; i++) {
		rho = 1.866*a*tan((90.- currObject->info.region.data[i].lat)*
		     drc/2.);
		ang = (center_lon - currObject->info.region.data[i].lon) * drc;
		p[i].x = (short)
		    ((rho*sin(ang)-mapleft)*xwa.width/(mapright-mapleft));
		p[i].y = (short)
		    ((-rho*cos(ang)-maptop)*xwa.height/(mapbottom-maptop));
		if (p[i].x > 0 && p[i].y > 0 && p[i].x < xwa.width &&
		    p[i].y < xwa.height) inbounds = TRUE;
	    }
	    if (inbounds) {
		if (display_depth == 1)
		    XSetStipple(d, gc, currObject->color);
		else
		    XSetForeground(d, gc, currObject->color);
		XFillPolygon(d, w, gc, p, currObject->info.region.count, 
		    Nonconvex, CoordModeOrigin);
		inbounds = FALSE;
	    }
	} else if (!(pref.disp_list[SHO_ARS])) {
	    continue;
	} else if (currObject->type == RADAR_PPI) {
	    rho = 1.866*a*tan((90.- currObject->info.ars.location.lat)*drc/2.);
	    ang = (center_lon -  currObject->info.ars.location.lon) * drc;
	    x = (short) ((rho*sin(ang)-mapleft)*xwa.width/(mapright-mapleft));
	    y = (short) ((-rho*cos(ang)-maptop)*xwa.height/(mapbottom-maptop));
	    XSetForeground(d, gc, currObject->color);
	    if (display_depth == 1)
		XSetFillStyle(d, gc, FillSolid);
	    centered_text(pref.font[BIGRADARFONT], currObject->info.ars.name, 
		x, y, TRUE);
	} else if ((currObject->type == RADAR_MT) ||
		   (currObject->type == RADAR_HOOK) ||
		   (currObject->type == RADAR_HAIL)) {
	    rho = 1.866*a*tan((90.- currObject->info.ars.location.lat)*drc/2.);
	    ang = (center_lon -  currObject->info.ars.location.lon) * drc;
	    x = (short) ((rho*sin(ang)-mapleft)*xwa.width/(mapright-mapleft));
	    y = (short) ((-rho*cos(ang)-maptop)*xwa.height/(mapbottom-maptop));
	    XSetForeground(d, gc, currObject->color);
	    if (display_depth == 1)
		XSetFillStyle(d, gc, FillSolid);
	    centered_text(pref.font[LILRADARFONT], currObject->info.ars.name, 
		x, y, FALSE);
	} else if (currObject->type == RADAR_MOVE) {
	    rho = 1.866*a*tan((90.-currObject->info.ars.location.lat)*drc/2.);
	    ang = (center_lon - currObject->info.ars.location.lon) * drc;
	    x = (short) ((rho*sin(ang)-mapleft)*xwa.width/(mapright-mapleft));
	    y = (short) ((-rho*cos(ang)-maptop)*xwa.height/(mapbottom-maptop));
	    draw_mvmt(currObject->info.ars.dir,currObject->info.ars.speed,x,y);
	}
    }
    free(p);
    if (display_depth == 1) XSetFillStyle(d, gc, FillSolid);
}





#define LEGBOXSIZE 21

draw_mdr_legend(bot) 
short *bot;
{
    int i, x, y;
    XCharStruct cs;
    int sl, dr, fa, fd;
    char *s;

    x = 2, y = *bot - 2 - LEGBOXSIZE;
    ClearPixmap(d, w, gc, x, y, LEGBOXSIZE*6, LEGBOXSIZE);
    XSetForeground(d, gc, pref.pix[DATA]);

    if (display_depth == 1)
	XSetFillStyle(d, gc, FillStippled);
    else
	XSetFillStyle(d, gc, FillSolid);
    
    for (i = 0; i < 6; i++) {
	if (display_depth == 1)
	    XSetStipple(d, gc, g[i]);
	else
	    XSetForeground(d, gc, pref.pix[vip[i]]);
	XFillRectangle(d, w, gc, x, y, LEGBOXSIZE-2, LEGBOXSIZE);
	x += LEGBOXSIZE;
    }

    XSetForeground(d, gc, pref.pix[DATA]);
    XSetFillStyle(d, gc, FillSolid);
    XSetFont(d, gc, pref.font[SUBTITLEFONT]->fid);

    y = xwa.height - 2 - LEGBOXSIZE - pref.font[SUBTITLEFONT]->descent;

    s = "Light"; sl = strlen(s);
    XDrawImageString(d,w, gc, 2, y, s, sl);

    s = "Heavy"; sl = strlen(s);
    XTextExtents(pref.font[SUBTITLEFONT], s, sl, &dr, &fa, &fd, &cs);
    XDrawImageString(d,w, gc, 2 + 6*LEGBOXSIZE - cs.width, y, s, sl);

    s = "Echo Intensities"; sl = strlen(s);
    y -= pref.font[SUBTITLEFONT]->ascent+pref.font[SUBTITLEFONT]->descent;
    XTextExtents(pref.font[SUBTITLEFONT], s, sl, &dr, &fa, &fd, &cs);
    XDrawImageString(d,w, gc, 2 + 3*LEGBOXSIZE - cs.width / 2, y, s, sl);

    *bot = y - pref.font[SUBTITLEFONT]->ascent - 10;
}





draw_mvmt(dir, speed, x, y) short dir, speed, x, y; {
    XSegment l[30];
    short li = 0, i;
    short nfull, nhalf;
    float rdir, cosdir, sindir;
    float yi;
    
    if (speed == 0) return;

    /*
    ** First determine how many full and half barbs there will be,
    ** and compute the angle of the symbol in radians.
    */
    nfull = speed / 10;
    nhalf = (speed - 10*nfull) >= 5;
    rdir = (float)dir * drc;
    cosdir = cos(rdir);
    sindir = sin(rdir);

    /*
    ** Build the stem.
    */
    l[li].x1 = x;
    l[li].y1 = y;
    l[li].x2 = x + (short) (40.*sindir);
    l[li].y2 = y + (short) (-40.*cosdir);
    li++;

    /*
    ** Build the arrowhead.
    */
    l[li].x1 = x;
    l[li].y1 = y;
    l[li].x2 = x + (short) (5.*cosdir + 5.*sindir);
    l[li].y2 = y + (short) (5.*sindir - 5.*cosdir);
    li++;
    l[li].x1 = x;
    l[li].y1 = y;
    l[li].x2 = x + (short) (-5.*cosdir + 5.*sindir);
    l[li].y2 = y + (short) (-5.*sindir - 5.*cosdir);
    li++;

    /*
    ** Build the full barbs.
    */
    for (i = 0, yi = 40.; i < nfull; i++, yi -= 5.) {
	l[li].x1 = x + (short) (yi*sindir);
	l[li].y1 = y + (short) (-yi*cosdir);
	l[li].x2 = x + (short) (15.*cosdir + (yi+4.)*sindir);
	l[li].y2 = y + (short) (15.*sindir - (yi+4.)*cosdir);
	li++;
	}
    
    /*
    ** Build the (possible) half barb.
    */
    if (nhalf) {
	l[li].x1 = x + (short) (yi*sindir);
	l[li].y1 = y + (short) (-yi*cosdir);
	l[li].x2 = x + (short) (8.*cosdir + (yi+2.)*sindir);
	l[li].y2 = y + (short) (8.*sindir - (yi+2.)*cosdir);
	li++;
	}
    
    /*
    ** DRAW!
    */
    XSetForeground(d, gc, pref.pix[DATA]);
    if (display_depth == 1)
	XSetFillStyle(d, gc, FillSolid);
    XSetLineAttributes(d, gc, 2, LineSolid, CapButt, JoinMiter);
    XDrawSegments(d, w, gc, l, li);
    XSetLineAttributes(d, gc, 0, LineSolid, CapButt, JoinMiter);
    }

