#include <stdio.h>

#define WE_TORN	1
#define WE_HAIL 2
#define WE_GAIL 3
#define WE_WIND 4

struct weatherEvent {
    float lat, lon;
    int type;	/* WE_TORN, WE_HAIL, ... */
    int event;
    int num;
    char location[85];
    char comments[85];
    struct weatherEvent *next;
};

struct weatherEvent *currentEvents;

main()
{
    char *cur;
    char line[85];
    char line2[85];
    char temp[6];
    int ilat, ilon;
    struct weatherEvent *we;

    currentEvents = NULL;
    while (!feof(stdin)) {
	fgets(line, 85, stdin);
	if (atoi(line) != 0) {
	    /* start of a new one */
	    we = (struct weatherEvent*) calloc(sizeof(struct weatherEvent), 1);
	    we->next = currentEvents;
	    currentEvents = we;
	    we->event = atoi(line);
	    switch (line[6]) {
		case 'T':
		    we->type = WE_TORN;
		    break;
		case 'A':
		    we->type = WE_HAIL;
		    break;
		case 'G':
		    we->type = WE_GAIL;
		    break;
		case 'W':
		    we->type = WE_WIND;
		    break;
	    }
	    strncpy(we->location, &line[14], 40);
	    cur = index(we->location, '(');
	    if (cur) *cur = '\0';

	    fgets(line2, 85, stdin);

	    strncpy(temp,&line2[69], 4);
	    temp[4] = '\0';
	    we->lat = atoi(temp)/100.0;

	    strncpy(temp,&line2[73], 5);
	    temp[5] = '\0';
	    we->lon = atoi(temp)/100.0;

	    strncpy(we->comments, &line2[11], 47);
	    printf("lat = %f, lon = %f\n", we->lat, we->lon);
	    printf("comments = %s\n", we->comments);
	    printf("location = %s\n", we->location);
	}
    }
}
