/*
 *
 *                  Copyright (c) 1992
 *                  Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/pref.c,v 1.5 1992/12/17 01:17:20 hollings Exp $";
#endif

/*
 * $Log: pref.c,v $
 * Revision 1.5  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.4  1992/12/16  19:24:33  hollings
 * fixes to compile with gcc.
 *
 * Revision 1.3  1992/11/25  19:34:42  hollings
 * removed dead variables.
 *
 * Revision 1.2  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.1  1992/04/24  20:45:46  hollings
 * Initial revision
 *
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/List.h>
#include <math.h>
#include <sys/time.h>

#include "windows.h"
#include "sadecode.h"
#include "map.h"

extern Pixmap icon_pixmap;
extern Widget top;

struct preference prefBu;

struct option {
    char *name;
    int value;
};

struct option Metric[] = {
    { "English", FALSE },
    { "Metric",	TRUE },
};

struct option Conditions[] = {
    { "Parsed",	FALSE },
    { "Raw",	TRUE },
};

struct option TimeZone[] = {
    { "Local",	FALSE },
    { "UTC",	TRUE },
};

struct option Legend[] = {
    { "Hidden",		FALSE },
    { "Visible",	TRUE },
};

CreatePrefPopup()
{
    int i;
    int acount;
    Arg args[80];
    XSizeHints hints;
    Widget lastWidget;
    Widget stn, left, tw, dw, pw;
    extern void prefCallBack();

    if (info.prefSheet) return;

    acount = 0;
    XtSetArg(args[acount], XtNsaveUnder, True); acount++;
    XtSetArg(args[acount], XtNx, (xwa.width - 450)/2); acount++;
    XtSetArg(args[acount], XtNy, (xwa.height - 250)/2 + 50); acount++;
    XtSetArg(args[acount], XtNiconPixmap, icon_pixmap); acount++;
    info.prefSheet = XtCreatePopupShell("Preferences", topLevelShellWidgetClass,
	info.pane, args, acount);
    
    acount = 0;
    XtSetArg(args[acount], XtNborderWidth, 25); acount++;
    dw = XtCreateManagedWidget("Options", formWidgetClass,
	info.prefSheet, args, acount);

    acount = 0;
    XtSetArg(args[acount], XtNy, 5); acount++;
    XtSetArg(args[acount], XtNlabel, "Display Preferences"); acount++;
    XtSetArg(args[acount], XtNfont, pref.font[TITLEFONT]); acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    lastWidget = XtCreateManagedWidget("title", labelWidgetClass, 
	dw, args, acount);

/*	NOT SUPPORTED YET
 *
 *  buildOptionList(&lastWidget, dw, "Units", Metric, 
 *	XtNumber(Metric), &pref.metric);
 *
 */

    buildOptionList(&lastWidget, dw, "Conditions", Conditions, 
	XtNumber(Conditions), &pref.rawConditions);
    buildOptionList(&lastWidget, dw, "Timezone", TimeZone, 
	XtNumber(TimeZone), &pref.gmtTime);
    buildOptionList(&lastWidget, dw, "Legend", Legend, 
	XtNumber(Legend), &pref.showLegend);

    acount = 0;
    XtSetArg(args[acount], XtNhorizDistance, 20); acount++;
    XtSetArg(args[acount], XtNfromVert, lastWidget); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Accept", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, prefCallBack, (XtPointer) 1);
    XtInstallAccelerators(stn, pw);

    acount = 0;
    XtSetArg(args[acount], XtNfromVert, lastWidget); acount++;
    XtSetArg(args[acount], XtNfromHoriz, pw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNhorizDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Cancel", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, prefCallBack, (XtPointer) 0);

    XtRealizeWidget(info.prefSheet);
    hints.x = xwa.width/2;
    hints.y = xwa.height/2;
    hints.flags = USPosition;
    XSetNormalHints(d, XtWindow(info.prefSheet), &hints);
}



buildOptionList(lt, parent, prompt, options, count, dest)
Widget *lt, parent;
char *prompt;
struct option options[];
int count;
int *dest;
{
    int i;
    int acount;
    Widget toggle;
    Arg args[80];
    void TogglePref();

    acount = 0;
    XtSetArg(args[acount], XtNfromVert, *lt); acount++;
    XtSetArg(args[acount], XtNvertDistance, 15); acount++;
    XtSetArg(args[acount], XtNlabel, prompt); acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    *lt = XtCreateManagedWidget("title", labelWidgetClass, parent,args, acount);

    toggle = NULL;
    for (i=0; i < count; i++) {
	acount = 0;
	XtSetArg(args[acount], XtNfromVert, *lt); acount++;
	XtSetArg(args[acount], XtNfromHoriz, toggle); acount++;
	XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
	XtSetArg(args[acount], XtNlabel, options[i].name); acount++;
	XtSetArg(args[acount], XtNradioGroup, toggle); acount++;
	XtSetArg(args[acount], XtNradioData, &(options[i].value)); acount++;
	if (options[i].value == *dest) {
	    XtSetArg(args[acount], XtNstate, True); acount++;
	}
	toggle = XtCreateManagedWidget("option", toggleWidgetClass, parent, 
	    args, acount);
	XtAddCallback(toggle, XtNcallback, TogglePref, dest);
    }
    *lt = toggle;
}


/* ARGSUSED */
void TogglePref(w, addr, dummy)
Widget w;
int *addr;
int *dummy;
{
    int *val;

    val = (int *) XawToggleGetCurrent(w);
    if (val) *addr = *val;
}

/* ARGSUSED */
void prefCallBack(buttonWidget, commit, cdata)
Widget buttonWidget;
int commit;
caddr_t cdata;
{
    XtPopdown(info.prefSheet);
    if (!commit) {
	memcpy(&pref, &prefBu, sizeof(pref));
    } else {
	resizePixmap();
    }
}
