
/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/regions.c,v 1.2 1992/07/02 19:39:23 hollings Exp $";
#endif

/*
 * $Log: regions.c,v $
 * Revision 1.2  1992/07/02  19:39:23  hollings
 * Color codeded watch boxes.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <X11/Intrinsic.h>
#include "sadecode.h"
#include "map.h"
#include "io.h"

#define streq !strcmp

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */

static double rhumblat(), rhumblon();

extern Pixmap gray1, gray2, gray3, gray4, gray5, gray6,
    gray7, gray8, gray9, hatch;

#define TORNADO_WATCH	1
#define	SVR_WATCH	2

#define	MAX_REGION	20
#define MAX_RGN_POINTS	50
struct region {
    struct locs r_v[MAX_RGN_POINTS];
    int r_npoints;
    char r_fill[3];
    char r_name[50];
    bool r_iswatchbox;
    int watchType;		/* TORNADO_WATCH, SVR_WATCH */
} regions[MAX_REGION];

int nregions = 0;

cmd_defregion(echo) bool echo; {
    int i;
    struct region *rgn;

    if (symc < 6) {
	puts("*** At least three fixes must be specified.");
	printf("*** Usage: %s name fillpattern vertex1 vertex2 ...\n",symv[0]);
	return;
	}
    
    rgn = &regions[nregions];
    
    rgn->r_npoints = 0;
    strcpy(rgn->r_name, symv[1]);
    rgn->r_fill[0] = symv[2][0];
    rgn->r_fill[1] = symv[2][1];
    rgn->r_fill[2] = '\0';
    if (!oneof(symv[2], "G1/G2/G3/G4/G5/G6/G7/G8/G9/H1/")) {
	printf("***  Unknown fill pattern: %s\n", symv[2]);
	return;
	}
    for (i = 3; i < symc; rgn->r_npoints++) {
	if (rgn->r_npoints >= MAX_RGN_POINTS) {
	    printf("error: region overflow\n");
	    exit(0);
	}
	if (doonepoint(&i, &rgn->r_v[rgn->r_npoints]) == FALSE) return;
    }
    rgn->r_iswatchbox = FALSE;
    nregions++;
    if (nregions >= MAX_REGION) {
	printf("region table overflow\n");
	exit(0);
    }
    if (echo)
	printf("Region %d: %d-point polygon defined.\n",
	    nregions, rgn->r_npoints);
    }





cmd_watch(echo) bool echo; {
    int i;
    struct region *rgn;
    struct locs endpt1, endpt2;
    int thickness;

    if (symc < 6) {
	printf("*** Usage: %s ww# size {ESO|EW|NS} endpoint1 endpoint2\n",
	    symv[0]);
	return;
	}
    
    rgn = &regions[nregions];

    rgn->r_npoints = 4;
    strcpy(rgn->r_name, symv[1]);
    if (!strncmp(rgn->r_name, "WT", 2)) {
	rgn->watchType = TORNADO_WATCH;
    } else if (!strncmp(rgn->r_name, "WS", 2)) {
	rgn->watchType = SVR_WATCH;
    } else {
	printf("*** Unknown watchbox type %s\n", symv[1]);
	rgn->watchType = TORNADO_WATCH;
    }

    if ((thickness = atoi(symv[2])) == 0) {
	printf("*** Bad watchbox thickness %s\n", symv[2]);
	return;
	}
    i = 4;
    if (doonepoint(&i, &endpt1) == FALSE) return;
    if (doonepoint(&i, &endpt2) == FALSE) return;

    if (!strncmp(symv[3], "EW", 2)) {
	float t;
	rgn->r_v[0].lat = t = rhumblat(endpt1.lat,endpt1.lon,270,thickness);
	rgn->r_v[0].lon =     rhumblon(t,endpt1.lon, 270, thickness);
	rgn->r_v[1].lat = t = rhumblat(endpt2.lat,endpt2.lon,270,thickness);
	rgn->r_v[1].lon =     rhumblon(t,endpt2.lon, 270, thickness);
	rgn->r_v[2].lat = t = rhumblat(endpt2.lat,endpt2.lon,90,thickness);
	rgn->r_v[2].lon =     rhumblon(t,endpt2.lon, 90, thickness);
	rgn->r_v[3].lat = t = rhumblat(endpt1.lat,endpt1.lon,90,thickness);
	rgn->r_v[3].lon =     rhumblon(t,endpt1.lon, 90, thickness);
	}
    
    else if (!strncmp(symv[3], "NS", 2)) {
	float t;
	rgn->r_v[0].lat = t = rhumblat(endpt1.lat,endpt1.lon,0,thickness);
	rgn->r_v[0].lon =     rhumblon(t,endpt1.lon, 0, thickness);
	rgn->r_v[1].lat = t = rhumblat(endpt1.lat,endpt1.lon,180,thickness);
	rgn->r_v[1].lon =     rhumblon(t,endpt1.lon, 180, thickness);
	rgn->r_v[2].lat = t = rhumblat(endpt2.lat,endpt2.lon,180,thickness);
	rgn->r_v[2].lon =     rhumblon(t,endpt2.lon, 180, thickness);
	rgn->r_v[3].lat = t = rhumblat(endpt2.lat,endpt2.lon,0,thickness);
	rgn->r_v[3].lon =     rhumblon(t,endpt2.lon, 0, thickness);
	}
    
    else if (!strncmp(symv[3], "ES", 2)) {
	float t, dist;
	short brg;
	float lata, latb, lona, lonb;
	lata = drc * endpt1.lat;
	latb = drc * endpt2.lat;
	lona = drc * endpt1.lon;
	lonb = drc * endpt2.lon;
	dist = acos(sin(lata)*sin(latb)+cos(lata)*cos(latb)*cos(lona-lonb));
	brg = (short) (rdc * acos((sin(latb)-sin(lata)*cos(dist)) /
	      (cos(lata)*sin(dist))));
	if (lonb > lona) brg = 360 - brg;
	rgn->r_v[0].lat = t = rhumblat(endpt1.lat,endpt1.lon,brg-90,thickness);
	rgn->r_v[0].lon =     rhumblon(t,endpt1.lon, brg-90, thickness);
	rgn->r_v[1].lat = t = rhumblat(endpt2.lat,endpt2.lon,brg-90,thickness);
	rgn->r_v[1].lon =     rhumblon(t,endpt2.lon, brg-90, thickness);
	rgn->r_v[2].lat = t = rhumblat(endpt2.lat,endpt2.lon,brg+90,thickness);
	rgn->r_v[2].lon =     rhumblon(t,endpt2.lon, brg+90, thickness);
	rgn->r_v[3].lat = t = rhumblat(endpt1.lat,endpt1.lon,brg+90,thickness);
	rgn->r_v[3].lon =     rhumblon(t,endpt1.lon, brg+90, thickness);
	}
    
    else printf("*** Unknown box orientation %s.\n", symv[3]);

    rgn->r_iswatchbox = TRUE;
    nregions++;
    if (echo) printf("Region %d: watchbox defined.\n", nregions);
    }






draw_region(type) 
int type;		/* SHO_WATCH || SHO_REGION */
{
    extern double center_lon;
    XPoint p[30];
    float rho, ang;
    short x, y;
    struct region *rgn;
    int i, j;

    if (nregions == 0 || !(pref.disp_list[type])) return;

    for (rgn = regions, j = 0; j < nregions; j++, rgn++) {
	int sumx = 0, sumy = 0;
	bool inbounds = FALSE;
	if (rgn->r_iswatchbox && (type != SHO_WATCH)) continue;
	if (!rgn->r_iswatchbox && (type != SHO_REGION)) continue;
	for (i = 0; i < rgn->r_npoints; i++) {
	    rho = 1.866*a*tan((90.-rgn->r_v[i].lat)*drc/2.);
	    ang = (center_lon - rgn->r_v[i].lon) * drc;
	    x = (short)((rho * sin(ang) - mapleft)*xwa.width/(mapright-mapleft));
	    y = (short)((-rho * cos(ang) - maptop)*xwa.height/(mapbottom-maptop));
	    if (x > 0 && y > 0 && x < xwa.width && y < xwa.height)
		inbounds = TRUE;
	    p[i].x = x;
	    p[i].y = y;
	    sumx += x, sumy += y;
	    }
	if (!inbounds) continue;
	if (rgn->r_iswatchbox) {
	    int np = rgn->r_npoints;
	    p[np].x = p[0].x;
	    p[np].y = p[0].y;
	    XSetLineAttributes(d, gc, 3, LineSolid, CapButt, JoinMiter);
	    if (rgn->watchType == SVR_WATCH) {
		XSetForeground(d, gc, pref.pix[SVR_W]);
	    } else {
		XSetForeground(d, gc, pref.pix[TOR_W]);
	    }
	    XDrawLines(d, w, gc, p, np + 1, CoordModeOrigin);
	    XSetLineAttributes(d, gc, 0, LineSolid, CapButt, JoinMiter);
	    }
	else {
	    Pixmap fill, makefillpix();
	    fill = makefillpix(rgn->r_fill);
	    XSetStipple(d, gc, fill);
	    XSetFillStyle(d, gc, FillStippled);
	    XSetForeground(d, gc, pref.pix[REGION]);
	    XFillPolygon(d,w,gc, p, rgn->r_npoints, Nonconvex,CoordModeOrigin);
	    XSetFillStyle(d, gc, FillSolid);
	    }
	XSetForeground(d, gc, pref.pix[DATA]);
	centered_text(pref.font[WATCHBOXFONT], rgn->r_name, sumx/rgn->r_npoints,
	    sumy/rgn->r_npoints, display_depth == 1? TRUE:FALSE);
	}
    }




Pixmap
makefillpix(s) char *s;
/* Return a pixmap made from one of the GRAY or HATCH include
** files, based on the name given in _s_.
*/ {
    if (streq(s, "G1"))
	return gray1;
    if (streq(s, "G2"))
	return gray2;
    if (streq(s, "G3"))
	return gray3;
    if (streq(s, "G4"))
	return gray4;
    if (streq(s, "G5"))
	return gray5;
    if (streq(s, "G6"))
	return gray6;
    if (streq(s, "G7"))
	return gray7;
    if (streq(s, "G8"))
	return gray8;
    if (streq(s, "G9"))
	return gray9;
    if (streq(s, "H1"))
	return hatch;
    }






static double
rhumblat(lat, lon, brg, dist) float lat, lon; short brg, dist;
/* Compute new latitude given old latitude and longitude, and
** a bearing in degrees from north and a distance in statute miles.
*/ {
    double rlat = lat * drc,
	   rbrg = (double)brg * drc,
	   rdist = (double)dist / 69. * drc,
	   res;

    res = asin(cos(rdist)*sin(rlat)+sin(rdist)*cos(rlat)*cos(rbrg));
    return res * rdc;
    }



static double
rhumblon(lat, lon, brg, dist) float lat, lon; short brg, dist;
/* Compute new longitude given NEW latitude and OLD longitude,
** and a bearing in degrees from north and a distance in statute miles.
*/ {
    double rlat = lat * drc,
	   rlon = lon * drc,
	   rbrg,
	   rdist = (double)dist / 69. * drc,
	   res;

    if (brg > 180)
	brg -= 360;
    
   rbrg = (double)brg * drc,

   res = asin(sin(rbrg)*sin(rdist)/cos(rlat));
   return lon - rdc * res;
   }






doonepoint(idx, loc) int *idx; struct locs *loc; {
    int dist, brg;
    struct report *r, *findstn();

    /*
    ** If the current entry is of the form 20 N CMI, pick off the
    ** distance and bearing, and try again recursively.
    */
    if (!symv[*idx]) {
	return;
    }
    if (strlen(symv[*idx]) < 3 && (dist = atoi(symv[*idx])) != 0) {
	if (*idx + 3 > symc) {
	    puts("*** Incomplete point at end of line.");
	    return FALSE;
	    }
	(*idx)++;
	if (!strcmp(symv[*idx], "N")) brg = 0;
	else if (!strcmp(symv[*idx], "NNE")) brg = 23;
	else if (!strcmp(symv[*idx], "NE")) brg = 45;
	else if (!strcmp(symv[*idx], "ENE")) brg = 68;
	else if (!strcmp(symv[*idx], "E")) brg = 90;
	else if (!strcmp(symv[*idx], "ESE")) brg = 113;
	else if (!strcmp(symv[*idx], "SE")) brg = 135;
	else if (!strcmp(symv[*idx], "SSE")) brg = 158;
	else if (!strcmp(symv[*idx], "S")) brg = 180;
	else if (!strcmp(symv[*idx], "SSW")) brg = 203;
	else if (!strcmp(symv[*idx], "SW")) brg = 225;
	else if (!strcmp(symv[*idx], "WSW")) brg = 248;
	else if (!strcmp(symv[*idx], "W")) brg = 270;
	else if (!strcmp(symv[*idx], "WNW")) brg = 293;
	else if (!strcmp(symv[*idx], "NW")) brg = 315;
	else if (!strcmp(symv[*idx], "NNW")) brg = 338;
	else {
	    printf("*** %s: unknown compass direction.\n", symv[*idx]);
	    return FALSE;
	    }
	(*idx)++;
	if (doonepoint(idx, loc) == FALSE) return FALSE;
	loc->lat = rhumblat(loc->lat, loc->lon, brg, dist);
	loc->lon = rhumblon(loc->lat, loc->lon, brg, dist);
	return TRUE;
    }

    /*
    ** If it is a single station of the form CMI, just pick up its
    ** latitude and longitude by looking it up in the database,
    ** and return it.
    */
    if ((r = findstn(symv[*idx])) == NULL) {
	/* printf("*** Station %s not found amongst reports.\n", symv[*idx]); */
	return FALSE;
    }
    loc->lat = r->lat;
    loc->lon = r->lon;
    (*idx)++;
    return TRUE;
    }
