
/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/report.c,v 1.5 1992/12/17 17:40:40 hollings Exp hollings $";
#endif

/*
 * $Log: report.c,v $
 * Revision 1.5  1992/12/17  17:40:40  hollings
 * added calls to strftime.
 *
 * Revision 1.4  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.3  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.2  1992/01/17  19:33:25  hollings
 * Removed printf's.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <string.h>
#include <sys/time.h>
#include <X11/Intrinsic.h>
#include "sadecode.h"
#include "map.h"

char *report(stn) 
char *stn;
{
    char *ch;
    FILE *fp;
    char file[80];
    struct report *r, *findstn();
    int i;

    /* for (ch = stn; *ch; ch++) *ch = toupper(*ch); */
    r = findstn(stn);
    if (!r) {
	return(NULL);
    }
    if (r->time[0] == 'M') {
	return(NULL);
    }

    memcpy(file, "/tmp/StnRptXXXXXX", strlen("/tmp/StnRptXXXXXX"));
    mktemp(file);
    fp = fopen(file, "w");
    if (!fp) return(NULL);

    do1report(r, fp);

    fclose(fp);
    return(file);
}



do1report(r, fp) 
struct report *r; 
FILE *fp;
{
    struct report tr;
    char buf[100];
    static char *cldprio = " sSbBoOxX";
    char *sky;
    char *curwx, *index();
    int i, len;
    struct timeval tv;
    struct timezone tz;

    memcpy(&tr, r, sizeof (struct report));
    r = &tr;

    if (r->nlayers == MISSING_I)
	curwx = NULL;
    else
	curwx = "Clear";
    sky = cldprio;
    for (i = 0; i < r->nlayers; i++) {
	char *s = index(cldprio, r->cover[i]);
	assert (s != NULL);
	if (s > sky) sky = s;
	}
    if (*sky == 's' || *sky == 'S') curwx = "Partly cloudy";
    else if (*sky == 'b' || *sky == 'B') curwx = "Mostly cloudy";
    else if (*sky == 'o' || *sky == 'O') curwx = "Cloudy";
    if (r->wx[0]) curwx = wxdecode(r->wx);

    gettimeofday(&tv, &tz);
    fprintf(fp, "Conditions at %s (%s, %s) at %c%c:%c%cUTC ", r->id, r->name,
	r->state, r->time[0], r->time[1], r->time[2], r->time[3]);
    dolocaltime(r->time, &tv, &tz, fp);
    fputs("\n", fp);
    fputs(r->raw, fp);

    fprintf(fp, "\n\nElevation: %d meters", r->elev);
    fprintf(fp, "           Station Priority: %d\n", r->prio); 
    fprintf(fp, "      Lat: %fN\t\t   Long: %fW\n", r->lat, r->lon);

    if (pref.rawConditions) return;

    if (curwx) fprintf(fp, "\n  Weather: %s\n", curwx);
    if (r->temp != MISSING_I) {
	fprintf(fp, "     Temp:%4d F", r->temp);
	if (r->wchill != MISSING_I)
	    fprintf(fp, "              Wind chill: %d F", r->wchill);
	else if (r->thi != MISSING_I && r->thi > 70) {
	    fprintf(fp, "          Temp-Hum Index: %d", r->thi);
	    if (r->thi > 92) fprintf(fp, " -DANGEROUS-");
	    else if (r->thi > 84) fprintf(fp, " -EXTREME-");
	    else if (r->thi > 79) fprintf(fp, " -HIGH-");
	    else if (r->thi > 75) fprintf(fp, " -MEDIUM-");
	    else fprintf(fp, " -LOW-");
	    }
	fputs("\n", fp);
	}
    if (r->rh != MISSING_I)
	fprintf(fp, " Humidity: %3d%%                 Dewpoint: %d F\n",
	    r->rh, r->dewpt);
    if (r->nlayers != MISSING_I) {
	fprintf(fp, "  Ceiling: ");
	switch (r->ceiltype) {
	    case ' ':
		fprintf(fp, "unlimited    ");
		break;
	    case 'E':
		fprintf(fp, "estim %5dft", 100 * r->height[r->ceillayer]);
		break;
	    case 'M':
		fprintf(fp, "meas  %5dft", 100 * r->height[r->ceillayer]);
		break;
	    case 'W':
		fprintf(fp, "indef %5dft", 100 * r->height[r->ceillayer]);
		break;
	    }
	}
    if (r->vis != MISSING_F)
	fprintf(fp, "      Visibility: %.2g mi", r->vis);
    if (r->nlayers != MISSING_I || r->vis != MISSING_F) fputs("\n", fp);
    if (r->altimeter != MISSING_F)
	fprintf(fp, "Barometer: %5.2f inHg\n", r->altimeter);
    if (r->wdir != MISSING_I) {
	if (r->wspd == 0)
	    fprintf(fp, "     Wind: calm\n");
	else {
	    float x;
	    x = 1.15 * (float)r->wspd;
	    fprintf(fp, "     Wind: %s %2d mph", winddir(r->wdir), (int)(.5+x));
	    if (r->wgust != MISSING_I) {
		x = 1.15 * (float)r->wgust;
		fprintf(fp, "  gusts to %d", (int)(.5+x));
		}
	    fputs("\n", fp);
	    }
	}
    if (r->nlayers != MISSING_I && r->nlayers > 0) {
	fprintf(fp, "   Clouds: ");
	for (i = 0; i < r->nlayers; i++) {
	    fprintf(fp, "%dft ", 100 * r->height[i]);
	    switch (r->cover[i]) {
		case 'o': fprintf(fp, "thin overcast ");       break;
		case 'O': fprintf(fp, "overcast ");            break;
		case 'b': fprintf(fp, "thin broken ");         break;
		case 'B': fprintf(fp, "broken ");              break;
		case 's': fprintf(fp, "thin scattered ");      break;
		case 'S': fprintf(fp, "scattered ");           break;
		case 'x': fprintf(fp, "partially obscured ");  break;
		case 'X': fprintf(fp, "sky obscured ");
		}
	    }
	fputs("\n", fp);
	}
    fputs("\n", fp);
}


#define SEC_PER_DAY	(3600 * 24)

dolocaltime(s, tvp, tzp, fp, sp) 
char *s; 
struct timeval *tvp; 
struct timezone *tzp; 
FILE *fp;
char *sp;
{
    time_t min;
    time_t sec;
    time_t hour;
    struct tm *tp;
    char str[80];


    min = 10 * (s[2] - '0') + (s[3] - '0');
    hour = 10 * (s[0] - '0') + (s[1] - '0');
    sec = (tvp->tv_sec / (SEC_PER_DAY)) * SEC_PER_DAY + hour * 3600 + min * 60;

    if (pref.gmtTime) {
	tp = gmtime(&sec);
    } else {
	tp = localtime(&sec);
    }

    if (fp) {
	strftime(str, sizeof(str), "(%H:%M %Z).", tp);
	fprintf(fp, str);
    } else {
	strftime(sp, 80, "%H:%M %Z", tp);
    }
}
