
/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/resources.c,v 1.9 1992/12/17 01:17:20 hollings Exp hollings $";
#endif

/*
 * $Log: resources.c,v $
 * Revision 1.9  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.8  1992/07/30  19:37:07  hollings
 * default server poona.cs.wisc.edu
 *
 * Revision 1.7  1992/07/02  19:40:07  hollings
 * color/mono split.
 *
 * Revision 1.6  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.5  1992/04/24  20:45:46  hollings
 * user preferences.
 *
 * Revision 1.4  1992/02/08  19:23:17  hollings
 * Changed man page file to xweather.
 *
 * Revision 1.3  1992/01/22  20:43:16  hollings
 * made location of man page a resource.
 *
 * Revision 1.2  1991/12/13  00:31:12  hollings
 * Made LIBDIR a resource.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xresource.h>
#include "map.h"

#define XtNgeometry		"geometry"
#define XtNmonochrome		"monochrome"
#define XtNforceColor		"forceColor"
#define XtNserverHost		"serverHost"
#define XtNserverPort		"serverPort"
#define XtNlibDirectory		"libDirectory"
#define XtNautoRescan		"autoRescan"
#define XtNrawConditions	"rawConditions"
#define XtNgmtTime		"gmtTime"
#define XtNidFont 		"idFont"
#define XtNdataFont		"dataFont"
#define XtNtitleFont		"titleFont"
#define XtNwatchBoxFont		"watchBoxFont"
#define XtNlegendFont		"legendFont"
#define XtNlargeARSFont		"largeARSFont"
#define XtNsmallARSFont		"smallARSFont"
#define XtNmapColor		"mapColor"
#define XtNdataColor		"dataColor"
#define XtNdimDataColor		"dimDataColor"
#define XtNregionColor		"regionColor"
#define XtNtornadoWatchBoxColor	"tornadoWatchBoxColor"
#define XtNsrvWatchBoxColor	"srvWatchBoxColor"
#define XtNvip1Color		"vip1Color"
#define XtNvip2Color		"vip2Color"
#define XtNvip3Color		"vip3Color"
#define XtNvip4Color		"vip4Color"
#define XtNvip5Color		"vip5Color"
#define XtNvip6Color		"vip6Color"
#define XtNwarmFrontColor	"warmFrontColor"
#define XtNcoldFrontColor	"coldFrontColor"
#define XtNstationaryFrontColor	"stationaryFrontColor"
#define XtNoccludedFrontColor	"occludedFrontColor"
#define XtNisoColor1		"isoColor1"
#define XtNisoColor2		"isoColor2"
#define XtNisoColor3		"isoColor3"
#define XtNdisplayARS		"ars"
#define XtNdisplayClouds	"clouds"
#define XtNdisplayDew  		"dew"
#define XtNdisplayFronts	"fronts"
#define XtNdisplayIsoBars	"isoBars"
#define XtNdisplayIsoDew	"isoDew"
#define XtNdisplayIsoTherms	"isoTherms"
#define XtNdisplayPressure	"pressure"
#define XtNdisplayRadar		"radar"
#define XtNdisplayRegions	"regions"
#define XtNdisplayNames		"names"
#define XtNdisplayTemp		"temp"
#define XtNdisplayVisibility	"visibility"
#define XtNdisplayWatches	"watches"
#define XtNdisplayWind		"wind"
#define XtNdisplayWS		"weatherSymbols"
#define XtNepoch		"epoch"
#define XtNhelpFile		"helpFile"
#define XtNshowLegend		"showLegend"

#define XtCGeometry		"geometry"
#define XtCInt			"integer"
#define XtCdisplayFlag		"displayFlag"

char picturetime[64];
char upperairtime[64];
extern Widget top;
int display_depth;
struct preference pref;

/*
** Command line options table.
*/
static XrmOptionDescRec opTable[] = {
    {"-background",	"*background",		XrmoptionSepArg,   NULL},
    {"-foreground",	"*foreground",		XrmoptionSepArg,   NULL},
    {"-bd",		"*borderColor",		XrmoptionSepArg,   NULL},
    {"-bg",		"*background",		XrmoptionSepArg,   NULL},
    {"-fg",		"*foreground",		XrmoptionSepArg,   NULL},
    {"-bordercolor",	"*borderColor",		XrmoptionSepArg,   NULL},
    {"-borderwidth",	"*borderWidth",		XrmoptionSepArg,   NULL},
    {"-bw",		"*borderWidth",		XrmoptionSepArg,   NULL},
    {"-color",		"*forceColor",		XrmoptionNoArg,    "on"},
    {"-database",	"*dataBase",		XrmoptionSepArg,   NULL},
    {"-display",	"*display",		XrmoptionSepArg,   NULL},
    {"-epoch",		"*epoch",		XrmoptionSepArg,   NULL},
    {"-monochrome",	"*monochrome",		XrmoptionNoArg,    "on"},
    {"-name",		"*name",		XrmoptionSepArg,   NULL},
    {"-reverse",	"*reverseVideo",	XrmoptionNoArg,    "on"},
    {"-rv",		"*reverseVideo",	XrmoptionNoArg,    "on"},
    {"-geometry",	"Xweather.geometry",	XrmoptionSepArg,   NULL},
};


static XrmDatabase commandlineDB;
XrmDatabase db = NULL;


extern int Argc;
extern char **Argv;
extern XtAppContext appConn;

Widget opendisplay() 
{
    char *type;
    XrmValue value; 

    top = XtAppInitialize(&appConn, "Xweather", opTable, XtNumber(opTable), 
	 &Argc, Argv, NULL, NULL, NULL);
    if (Argc > 1) {
	fprintf(stderr, "!!! Bad command line option: %s.\n", Argv[1]);
	exit(1);
    }
    
    d = XtDisplay(top);
    return(top);
}

static int value = 0;

static XtResource resources[] = {
    {XtNmonochrome, XtCBoolean, XtRBoolean, sizeof(Boolean),
	XtOffset(pPtr, monochrome), XtRImmediate, (caddr_t) FALSE },
    {XtNforceColor, XtCBoolean, XtRBoolean, sizeof(Boolean),
	XtOffset(pPtr, forcecolor), XtRImmediate, (caddr_t) FALSE },
    {XtNreverseVideo, XtCBoolean, XtRBoolean, sizeof(Boolean),
	XtOffset(pPtr, reverse), XtRImmediate, (caddr_t) FALSE },
    {XtNserverHost, XtCString, XtRString, sizeof(char *),
	XtOffset(pPtr, serverHost), XtRString, "lemon.cs.wisc.edu" },
    {XtNserverPort, XtCInt, XtRInt, sizeof(int),
	XtOffset(pPtr, serverPort), XtRImmediate, (caddr_t) 612 },
    {XtNlibDirectory, XtCString, XtRString, sizeof(char *),
	XtOffset(pPtr, libDirectory), XtRString, WORKINGDIRECTORY },
    {XtNautoRescan, XtCBoolean, XtRBoolean, sizeof(int),
	XtOffset(pPtr, autoRescan), XtRImmediate, (caddr_t) 1 },
    {XtNrawConditions, XtCBoolean, XtRBoolean, sizeof(Boolean),
 	XtOffset(pPtr, rawConditions), XtRImmediate, (caddr_t) FALSE },
    {XtNgmtTime, XtCBoolean, XtRBoolean, sizeof(Boolean),
 	XtOffset(pPtr, gmtTime), XtRImmediate, (caddr_t) FALSE },
    {XtNshowLegend, XtCBoolean, XtRBoolean, sizeof(Boolean),
 	XtOffset(pPtr, showLegend), XtRImmediate, (caddr_t) TRUE },
    {XtNidFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	XtOffset(pPtr, font[0]), XtRString, (caddr_t) 
	"*-fixed-medium-r-normal-*-10-*" },
    {XtNdataFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	XtOffset(pPtr, font[1]), XtRString, (caddr_t) 
	"*-fixed-medium-r-normal-*-8-*" },
    {XtNtitleFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
    	XtOffset(pPtr, font[2]), XtRString, (caddr_t) 
	"*-new century schoolbook-medium-r-*-*-18-*" },
    {XtNwatchBoxFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
    	XtOffset(pPtr, font[3]), XtRString, (caddr_t) 
	"*-new century schoolbook-bold-i-*-*-12-*" },
    {XtNlegendFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
        XtOffset(pPtr, font[4]), XtRString, (caddr_t) 
	"*-new century schoolbook-medium-r-*-*-10-*" },
    {XtNlargeARSFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
        XtOffset(pPtr, font[5]), XtRString, (caddr_t) 
	"*-courier-medium-r-*-*-18-*"},
    {XtNsmallARSFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
    	XtOffset(pPtr, font[6]), XtRString, (caddr_t) 
	"*-courier-bold-o-*-*-12-*"},
    {XtNbackground, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[BG]), XtRString, (caddr_t) "white"},
    {XtNdisplayARS, XtCdisplayFlag, XtRBoolean, sizeof(int),
	XtOffset(pPtr, disp_list[SHO_ARS]), XtRString, (caddr_t) "False"},
    {XtNdisplayClouds, XtCdisplayFlag, XtRBoolean, sizeof(int),
	XtOffset(pPtr, disp_list[SHO_CLD]), XtRString, (caddr_t) "False"},
    {XtNdisplayDew, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_DEWP]), XtRString, (caddr_t) "False"},
    {XtNdisplayFronts, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_FRONT]), XtRString, (caddr_t) "False"},
    {XtNdisplayIsoBars, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_ISOBAR]), XtRString, (caddr_t) "False"},
    {XtNdisplayIsoDew, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_ISODROSO]), XtRString, (caddr_t) "False"},
    {XtNdisplayIsoTherms, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_ISOTHERM]), XtRString, (caddr_t) "False"},
    {XtNdisplayPressure, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_PRES]), XtRString, (caddr_t) "False"},
    {XtNdisplayRadar, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_RADSUM]), XtRString, (caddr_t) "True"},
    {XtNdisplayRegions, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_REGION]), XtRString, (caddr_t) "False"},
    {XtNdisplayNames, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_NAME]), XtRString, (caddr_t) "False"},
    {XtNdisplayTemp, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_TEMP]), XtRString, (caddr_t) "True"},
    {XtNdisplayVisibility, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_VIS]), XtRString, (caddr_t) "False"},
    {XtNdisplayWatches, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_WATCH]), XtRString, (caddr_t) "False"},
    {XtNdisplayWind, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_WIND]), XtRString, (caddr_t) "False"},
    {XtNdisplayWS, XtCdisplayFlag, XtRBoolean, sizeof(char),
	XtOffset(pPtr, disp_list[SHO_WX]), XtRString, (caddr_t) "False"},
    {XtNgeometry, XtCGeometry, XtRString, sizeof(char *),
	XtOffset(pPtr, geometry), XtRString, (caddr_t) NULL },
    {XtNepoch, XtCString, XtRString, sizeof(char *),
	XtOffset(pPtr, epochTime), XtRString, (caddr_t) NULL },
    {XtNhelpFile, XtCString, XtRString, sizeof(char *),
	XtOffset(pPtr, helpFile), XtRString, (caddr_t) 
	    "/usr/unsup/man/catl/xweather.l" },
};

static XtResource colorResources[] = {
    {XtNmapColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[MAP]), XtRString, (caddr_t) "purple"},
    {XtNdataColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[DATA]), XtRString, (caddr_t) "black"},
    {XtNdimDataColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[DIMDATA]), XtRString, (caddr_t) "blue"},
    {XtNregionColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[REGION]), XtRString, (caddr_t) "yellow"},
    {XtNtornadoWatchBoxColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[TOR_W]), XtRString, (caddr_t) "red"},
    {XtNsrvWatchBoxColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[SVR_W]), XtRString, (caddr_t) "blue"},
    {XtNvip1Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP1]), XtRString, (caddr_t) "#009000"},
    {XtNvip2Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP2]), XtRString, (caddr_t) "#00d000"},
    {XtNvip3Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP3]), XtRString, (caddr_t) "green"},
    {XtNvip4Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP4]), XtRString, (caddr_t) "yellow"},
    {XtNvip5Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP5]), XtRString, (caddr_t) "orange"},
    {XtNvip6Color, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[VIP6]), XtRString, (caddr_t) "red"},
    {XtNwarmFrontColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[WF]), XtRString, (caddr_t) "red"},
    {XtNcoldFrontColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[CF]), XtRString, (caddr_t) "cyan"},
    {XtNstationaryFrontColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[SF]), XtRString, (caddr_t) "green"},
    {XtNoccludedFrontColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[OF]), XtRString, (caddr_t) "magenta"},
    {XtNborderColor, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[BORDER]), XtRString, (caddr_t) "white"},
    {XtNisoColor1, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[ISOPLET]), XtRString, (caddr_t) "green"},
    {XtNisoColor2, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[ISOPLE2]), XtRString, (caddr_t) "green"},
    {XtNisoColor3, XtCColor, XtRPixel, sizeof(Pixel),
	XtOffset(pPtr, pix[ISOPLE3]), XtRString, (caddr_t) "green"},
};

getdefaults() 
{
    int colorDisplay;

    XtGetApplicationResources(top, (caddr_t) &pref,
        resources, XtNumber(resources), 0, 0);

    /* for backward compatability */
    XtGetSubresources(top, (caddr_t) &pref, "display", "Display",
        resources, XtNumber(resources), 0, 0);

    colorDisplay = (XDisplayCells(d, DefaultScreen(d)) > 2);
    if (!colorDisplay) {
	XtGetSubresources(top, (caddr_t) &pref, "mono", "Mono",
	    colorResources, XtNumber(colorResources), 0, 0);
    } else {
	XtGetSubresources(top, (caddr_t) &pref, "color", "Color",
	    colorResources, XtNumber(colorResources), 0, 0);
    }
}
