/*
 *                Copyright 1989 by Douglas A. Young
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation. The author disclaims all warranties with 
 * regard to this software, including all implied warranties of 
 * merchantability and fitness.
 *
 * Comments and additions may be sent the author at:
 *
 *  dayoung@hplabs.hp.com
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/nwxmap/RCS/rubberband.c,v 1.1 1991/12/10 16:51:29 hollings Exp $";
#endif

/*
 * $Log: rubberband.c,v $
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */


/***********************************************
 * rubberband.c: rubberband line example
 ***********************************************/
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h> 
#include <X11/cursorfont.h>
#include <X11/Xaw/Label.h>
#include "rubberband.h"

void start_rubber_band();
void end_rubber_band();
void track_rubber_band();

initRubberBand(w, data, fg, bg)
        Widget            w;
        rubber_band_data *data;
	int fg, bg;
{
  XGCValues values;
  Arg       wargs[2];

  /*
   * Set the rubber band gc to use XOR mode and draw 
   * a dashed line.
   */
  values.foreground = fg ^ bg;
  values.background = bg;
  values.line_style = LineOnOffDash;
  values.function = GXxor;
  data->active = FALSE;
  data->gc = XtGetGC(w, GCForeground | GCBackground | 
                        GCFunction | GCLineStyle, &values);
}

void start_rubber_band(w, data, event)
        Widget             w;
        rubber_band_data   *data;
        XEvent             *event;
{
   data->last_x  =  data->start_x = event->xbutton.x;
   data->last_y  =  data->start_y = event->xbutton.y;
   XDrawLine(XtDisplay(w), XtWindow(w), 
             data->gc, data->start_x, 
             data->start_y, data->last_x, data->last_y);
   data->active = TRUE; 
}

void track_rubber_band(w, data, event)
        Widget          w;
        rubber_band_data      *data;
        XEvent         *event;
{
  if (!data->active) return;

  /*
   * Draw once to clear the previous line.
   */
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->start_y, 
            data->last_x, data->start_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->start_y, 
            data->last_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->last_y, 
            data->start_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->last_y, 
            data->start_x, data->start_y);
  /*
   * Update the endpoints.
   */
  data->last_x  =  event->xbutton.x;
  data->last_y  =  event->xbutton.y;
  /*
   * Draw the new box
   */
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->start_y, 
            data->last_x, data->start_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->start_y, 
            data->last_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->last_y, 
            data->start_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->last_y, 
            data->start_x, data->start_y);
}

void end_rubber_band(w, data, event)
Widget            w;
rubber_band_data *data;
XButtonEvent           *event;
{
  data->active = FALSE; 
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->start_y, 
            data->last_x, data->start_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->start_y, 
            data->last_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->last_x, data->last_y, 
            data->start_x, data->last_y);
  XDrawLine(XtDisplay(w), XtWindow(w), data->gc, 
            data->start_x, data->last_y, 
            data->start_x, data->start_y);

  data->last_x  =  event->x;
  data->last_y  =  event->y;
}
