
/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
*/
#ifndef lint
static char rcsid[] = "@(#) $Header: /usr/home/hollings/src/original/xweather/RCS/sadecode.c,v 1.3 1992/12/17 01:17:20 hollings Exp hollings $";
#endif

/*
 * $Log: sadecode.c,v $
 * Revision 1.3  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.2  1991/12/10  22:39:44  hollings
 * Fixed bug that caused the program to delete light/heavy modifier when
 * the function was called twice on the same station.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */


#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "sadecode.h"

#define streq !strcmp

static separate(), wind(), argline(),  unpack(), parmscan(), analyze();
static do_windchill(), do_heatindex(), do_humidity();

static struct report *stn;
static char *Arg[50],
            *Num[5];
static int numargs;

struct report *
sadecode(Line, r) char *Line; struct report *r; {
   char temp[40],
        temp2[40];
   int i, ii, j, jj, len;
   static float dovisibility();


      stn = r;
      while (Line[0] == ' ') Line++;		/* Skip leading blanks */

      argline(Line);
      if (numargs < 3) return NULL;
      for(i=2; ((analyze(Arg[i])>0) ||(strlen(Arg[i])!=4))&&(i<numargs); i++);
      if (i == numargs)   /* error- no time */
	 return NULL;
      strncpy(stn->time, Arg[i++], 4);
      stn->time[4] = '\0';

      stn->nlayers = stn->ceillayer = 0;
      stn->pmb = stn->altimeter = stn->vis = MISSING_F;
      stn->temp = stn->dewpt = stn->wdir = stn->wspd = stn->wgust =
	  stn->heat = stn->thi = stn->wchill = stn->rh = MISSING_I;
      stn->ceiltype = ' ';
      stn->wx[0] = '\0';

      /*
      ** If this is an ASOS report, skip over the designator saying so.
      */
      if (Arg[i] && (strncmp(Arg[i], "A02", 3) == 0)) i++;

      /*
      ** Here's a hack to handle the nonstandard but widespread convention
      ** of putting "X" or "-X" in front of the rest of the report.
      */
      if (Arg[i] && (streq(Arg[i], "-X") || streq(Arg[i], "X"))) {
	 /*
	 if (*Arg[i] == '-') stn->cover[stn->nlayers] = 'x';
	 else stn->cover[stn->nlayers] = 'X';
	 */
	 i++;
	 }

	   /* now do sky and ceiling */
      while(analyze(Arg[i])!=1 && i+1 < numargs && (analyze(Arg[i+1])==1||analyze(Arg[i])==3)){

	 if (analyze(Arg[i])!=3){
	    strncpy(temp, Arg[i],40);
	    strncpy(temp2, Arg[i+1],40);
	    }
	else {
	   separate(Arg[i], temp, temp2);
	   }

	 /* now hang on one moment...how do we know now that this isn't
	    the visibility and weather figure? let's check...  */
	 if (temp2[0] == '-') 
	    j =1;
	 else j=0;
	 if ((temp2[j]=='S')&&(temp2[j+1]=='C')) ;
	 else if ((temp2[j]=='B')&&(temp2[j+1]=='K')) ;
	 else if ((temp2[j]=='O')&&(temp2[j+1]=='V')) ;
	 else if (temp2[j]=='X');
	 else 
	    break; /* it must be a visibility figure */

	 if (analyze(Arg[i])!=3)
            i+=2;
	 else i++;

	 if (temp[0]=='E' || temp[0] == 'M' || temp[0] == 'W') {
	     stn->ceiltype = temp[0];
	     stn->ceillayer = stn->nlayers;
	     temp[0]=' ';
	     }
	 len = strlen(temp) - 1;
	 if (temp[len]=='V') temp[len] = '\0';
	 stn->height[stn->nlayers] = atoi(temp);
	 if (temp2[0] == '-') j = 1; else j = 0;
	 if ((temp2[j]=='S')&&(temp2[j+1]=='C'))
	    stn->cover[stn->nlayers] = j? 's':'S';
	 else if ((temp2[j]=='B')&&(temp2[j+1]=='K'))
	    stn->cover[stn->nlayers] = j? 'b':'B';
	 else if ((temp2[j]=='O')&&(temp2[j+1]=='V'))
	    stn->cover[stn->nlayers] = j? 'o':'O';
	 else if (temp2[j]=='X')
	    stn->cover[stn->nlayers] = j? 'x':'X';

	 stn->nlayers++;
         } /* while ## clouds */

      if (i >= numargs) {
	 return stn;
	 }

      if (strcmp(Arg[i], "CLR")==0) {
	 i++;
	 }
      else if (stn->nlayers == 0)
	stn->nlayers = MISSING_I;

	  /* now do visibility and weather */
      j = analyze(Arg[i]);
      if (j == 0){
	 stn->vis = dovisibility(Arg[i++]);
         if (analyze(Arg[i])==1)   /* weather/visibility are separate */
	    strncpy(stn->wx, Arg[i++], 9);
	 }
      else if ((j==3)||(j==4 && (Arg[i][0]!='0' && Arg[i][0]!='9'))) {
	 len = strlen(Arg[i]);
	 for (ii=0, jj=0; isdigit(Arg[i][ii])||Arg[i][ii]=='/'&&ii<len;)
	    temp[jj++] = Arg[i][ii++];
	 temp[jj] = '\0';
	 stn->vis = dovisibility(temp);
	 strncpy(stn->wx, Arg[i]+ii, 9);
	 i++;
	 }
	 
	 /* now find something with a slash in it */
      for(; i < numargs && analyze(Arg[i])!= 4 ; i++);
      if (analyze(Arg[i])!=4) { 
	 return stn;
	 }
	       /* divide the slashed item into smaller items */
      jj = unpack(i);

	/* Look for leading E for figures signifying "estimated", remove
	   it. */
      for(ii=0; ii < jj ; ii++)
	 {
	 if (Num[ii][0] == 'E') {
	    int place;
	    for (place=0; place < strlen(Num[ii]); place++)
	       Num[ii][place] = Num[ii][place + 1];
	    }
	 }

		/* now look for the wind */
      for(ii=0; ii < jj && (strlen(Num[ii]) < 5 || analyze(Num[ii])!=3); ii++);
      if (ii < jj) {
	 strncpy(temp, Num[ii], 7);
	 strncpy(temp2, Num[ii], 2);
	 temp2[2] = '\0';
	 if (wind(temp2)== 1) {
	    stn->wspd = (temp[2] - '0') * 10 + temp[3] - '0';
	    stn->wgust = (temp[5] - '0') * 10 + temp[6] - '0';
	    }
	 }
      else {
	 for(ii=0;ii< jj && (strlen(Num[ii]) < 4 || analyze(Num[ii])!=0); ii++);
         if (ii < jj) {
	    strncpy(temp2, Num[ii], 2);
	    temp2[2] = '\0';
	    strncpy(temp, Num[ii], 4);
	    if (wind(temp2)== 1)
	       stn->wspd = (temp[2] - '0') * 10 + temp[3] - '0';
	    }
	 }

      if ((ii-2 >=0)&&(analyze(Num[ii-2])==0))
	 stn->temp =  atoi(Num[ii-2]);
      if ((ii-1 >=0)&&(analyze(Num[ii-1])==0))
	 stn->dewpt = atoi(Num[ii-1]);
      if (jj > ii+1 && analyze(Num[ii+1])==0) {
	 strncpy(temp, Num[ii+1], 3);
	 if (temp[0] > '5') jj = 2;
	 else jj = 3;
	 stn->altimeter = (float) jj * 10. + (float)(temp[0] - '0');
	 stn->altimeter += (float)(temp[1]-'0')/10. + (float)(temp[2]-'0')/100.;
	 }

   /*
   ** Handle the metric non-US data.
   */
   if (stn->sys == 'M') {
       if (stn->temp != MISSING_I) stn->temp = stn->temp*9./5. + 32.;
       if (stn->dewpt != MISSING_I) stn->dewpt = stn->dewpt*9./5. + 32.;
       }

   /*
   ** Do some sanity checks on the data received!
   */
   if (stn->temp < -150 || stn->temp > 150) stn->temp = MISSING_I;
   if (stn->dewpt < -150 || stn->dewpt > 150) stn->dewpt = MISSING_I;
   if (stn->vis > 200. || stn->vis < 0.) stn->vis = MISSING_F;
   if (stn->temp < stn->dewpt) stn->dewpt = MISSING_I;
   if (stn->wgust < 0 || stn->wgust < stn->wspd) stn->wgust = MISSING_I;
   if (stn->wspd < 0 || stn->wspd > 150) stn->wspd = MISSING_I;
   if (stn->altimeter > 32.00 || stn->altimeter < 25.00)
      stn->altimeter = MISSING_F;
   if ((stn->wdir<0 || stn->wdir>360) && stn->wdir != 990)
      stn->wdir = MISSING_I;
   /*
   ** If we have all the things we need to do some fun calculations,
   ** do them.
   */
   if (stn->temp!=MISSING_I && stn->dewpt!=MISSING_I) {
       do_humidity();
       do_heatindex();
       }
   if (stn->temp!=MISSING_I && stn->wspd!=MISSING_I) do_windchill();
   return stn;

}/* judy */
/*------------------------------------------------------------------------*/
/* this function's sole purpose in life is to separate the numbers in
   a word from the characters
 */

static separate(st, array1, array2) 
char *array1, *array2;
char* st;
{
int len, i, ii;
	strcpy(array1, st);
	len = strlen(array1);
	for (i=0; (isdigit(array1[i]) && i < len); i++) ;
	if (i < len) {
		for (ii=0; array2[ii] = array1[i+ii]; ii++);
		array1[i] = '\0';
		}

} /* separate */





static wind(st) char *st; {
   if (analyze(st) !=0) return 0;
   stn->wdir = 10 * atoi(st);
   return 1;
   }







#define  ARGNUM		49
/*---------------------------------------------------------------------------*/
static int
argline(p) char *p; {
int j, jj;    /* arg index */
   j = 0;
   Arg[j] = p;
   while(parmscan(&p, 1) && j < ARGNUM) {
      Arg[++j] = p;
      }
   j++;
   for (jj = j;jj <= ARGNUM; jj++)
      Arg[jj] = 0;
   numargs = j;
   return;
}/* argline */
/*---------------------------------------------------------------------------*/


#define  ARGNUM2	4
static int 
unpack(i)
int i;
{
int j, jj;    /* arg index */
char *p;
   p = Arg[i];
   j = 0;
   Num[j] = p;
   while(parmscan(&p, 0) && j < ARGNUM2) {
      Num[++j] = p;
      }
   j++;
   for (jj = j;jj <= ARGNUM2; jj++)
      Num[jj] = 0;
   return j;
}/* unpack */

/*---------------------------------------------------------------------------*/


static
parmscan(p, which)
char **p;
int which;
{
char *q;
   q= *p;
   while (*q && ((isalnum(*q)||(*q=='+')||(*q=='-')||((*q=='/')&& which)))) q++;
   if (*q == '\0') return 0;
   *q++ = '\0';
   while (*q && isspace(*q)) q++;
   if (*q == '\0') return 0;
   *p = q;
   return 1;
   }

/*-------------------------------------------------------------------------*/


/* analyze returns the following:
 * 0 a string is made up of only digits.  
 * 1 only chars
 * 2 starts with one or more char and then digits
 * 3 starts with one or more digits and ends with one or more chars
 * 4 has a "/"
 * 5 none of the above
 */

static int
analyze(st) char *st; {
   int len, i;

   if (st == NULL) return 5;
   len = strlen(st);
   if (len ==0) return 5;
   if (strchr(st, '/')) return 4;
   for(i=0; i < len && (isdigit(st[i])||st[i]=='-') ; i++);
   if (i==len) return 0;
   if (i > 0 && st[i-1]!= '-')  return 3;
   for(i=0; i < len && (isalpha(st[i]) || st[i]== '-' || st[i]=='+'); i++);
   if (i==len) return 1;
   if (i > 0)  return 2;
   return 5;
} /* analyze */
/*-------------------------------------------------------------------------*/

static
do_humidity()
/*
** Compute and print the relative humidity if the temperature and dewpoint
** are both present. The equation was derived from an icky BASIC program
** written by A. K. Blackadar.
*/ {
    double t, d;
    double rh;

    t = 273.15 + (stn->temp - 32.) * 5. / 9.;
    d = 273.15 + (stn->dewpt - 32.) * 5. / 9.;
    stn->rh = (int) (.5 + 100. * exp(5351./t - 5351./d));
    }



static
do_windchill() 
/*
** Compute and print the wind chill factor if the temperature and wind
** velocity are both present. Don't print it if the wind is too slow or
** the temperature too high or the wind chill not sufficiently different
** from the temperature. The equation is from an icky BASIC program
** written by A. K. Blackadar.
*/ {
    double t, w;
    double wc;

    t = (double) stn->temp;
    w = (double) stn->wspd * 1.15;
    if (t >= 91.4) return;
    wc = 91.4 - (91.4-t)*(.478+.301*sqrt(w)-.02*w);
    if (t - wc < 5. || wc > 50.) return;
    stn->wchill = (int) (.5 + wc);
    }



static
do_heatindex()
/*
** Compute the Heat Index and Temperature-Humidity Index if
** the temperature and relative humidity if both are both present.
**
** Heat index foruma from Gary Skaggs, NSSL. He says "This is a very
** simplified approach to Steadman's Heat Index calculation from
** Monthy Weather Review from the early 80's or late 70's."
*/ {
    float a, tf = stn->temp, rh = stn->rh / 100.;

    a = 16.923 + 0.185212 * tf + 5.37941 * rh - 0.100254 * tf * rh;
    a += 0.941695e-2 * tf*tf + 0.728898e-2 * rh*rh + 0.345372e-3 * tf*tf * rh;
    a -= 0.814971e-3 * tf * rh*rh + 0.102102e-4 * tf*tf * rh*rh;
    a -= 0.38646e-4 * tf*tf*tf + 0.291583e-4 * rh*rh*rh +
	 0.142721e-5 * tf*tf*tf * rh;
    a += 0.197483e-6 * tf * rh*rh*rh - 0.218429e-7 * tf*tf*tf * rh*rh;
    a += 0.843296e-9 * tf*tf * rh*rh*rh - 0.481975e-10 * tf*tf*tf * rh*rh*rh;
    stn->heat = (int) (a + 0.5);


    stn->thi = (int) (.55 * (float)stn->temp + .2 * (float)stn->dewpt + 17.5);
    return;
    }



static float
dovisibility(s) char *s;
/*
** Given a string which may contain a fraction, convert it to a floating
** point number. "2" -> 2.0; "11/2" -> 1.5; "7/8" -> 0.875.
*/ {
    double res = 0.;

    /*
    ** If the character following the current one is a slash, then the
    ** current character is the numerator of the fraction and the string
    ** following the slash is the denominator.
    */
    while (*s && (isdigit(*s) || *s == '/')) {
	if (s[1] == '/') {
	    double denom = atof(s+2);
	    if (denom == 0.0) return res;
	    res += (double)(s[0]-'0') / denom;
	    return res;
	    }
	else
	    res = 10.*res + (double)(s[0]-'0');
	s++;
	}
    return res;
    }







char *
wxdecode(arg) char *arg;
/* Take a string of characters and translate it into text. The
** codes are based on assumption that word adjectives are before
** the nouns they modify and + and - come after the noun phrases
** they modify.
*/
{

    /* 0 for nouns, 1 for adjectives, 2 for either */
    static char *part = "010001010000220001";
    static char *key  = "ABCDFGHIKLNPRSTWYZ";
    static char *keyword[18] = {
	"hail", "blowing", "crystals", "dust", "fog", "ground", "haze",
	"ice", "smoke", "drizzle", "sand", "pellets", "rain", "snow",
	"thunder", "shower", "spray", "freezing"
	};
    char st[64];
    static char result[64];
    int ii = 0, jj, a, len, inc = 1;

    strncpy(st, arg, 64);
    result[0] = result[1] = '\0';
    for(len = strlen(st); isprint(st[ii]) && ii< len; ii++){

       for(jj=0; st[ii]!=key[jj] && jj< 18; jj++);

       /* go until we recognize something */
       while(jj>=18) {
	   ii++;
	   if (ii >= len) goto finish;
           for(jj=0; st[ii]!=key[jj] && jj< 18; jj++);
	   }
	
       /* if we have rain followed by showers */
       /* if last word was a noun */
       if (!inc || (inc==2 && st[ii]!='W')) strcat(result, " and");
       if (jj < 18) inc = part[jj] - 48;
       else inc = 1;

	/*
	   once we translate, can just replace char with a space,
	   which will be ignored by case
	   if it is a noun, say 'and' after it and look one ahead
	   if adj, look two ahead */

       if (ii+1 < len && st[ii+1]=='-'){
	      strcat(result, " light");
	      st[ii+1] = ' ';
	      }
       if (ii+1 < len && st[ii+1]=='+'){
	      strcat(result, " heavy");
	      st[ii+1] = ' ';
	      }

       if (ii+2 < len && st[ii+2]=='-' ){
           for(a=0; st[ii]!=key[a] && a< 18; a++);
	   /* has to be either an adjective or rain followed by showers */
	   if (a< 18 && part[a] == '1'||((st[ii]=='R' || st[ii] =='S') && st[ii+1]=='W')) {
	      strcat(result, " light");
	      st[ii+2] = ' ';
	      }
	   }

       if (ii+2 < len && st[ii+2]=='+' ){
           for(a=0; st[ii]!=key[a] && a< 18; a++);
	   if (a< 18 && part[a] == '1'||((st[ii]=='R'||st[ii]=='S') && st[ii+1]=='W')) {
	      strcat(result, " heavy");
	      st[ii+2] = ' ';
	      }
	   }

	if (jj<18) {
        	strcat(result, " ");
		strcat(result, keyword[jj]);
		}
      } /* for */
finish:
    if (islower(result[1])) result[1] = toupper(result[1]);
    return result+1;
    }




char *
winddir(x) int x;
/* Convert a wind direction in degrees to a string direction,
** like "N" or "SE".
*/ {
    if (x > 340 || x <=  20) return "N";
    if (x >  20 && x <=  70) return "NE";
    if (x >  70 && x <= 110) return "E";
    if (x > 110 && x <= 160) return "SE";
    if (x > 160 && x <= 200) return "S";
    if (x > 200 && x <= 250) return "SW";
    if (x > 250 && x <= 290) return "W";
    if (x > 290 && x <= 340) return "NW";
    return "??";
    }





/**********************************************************************
   Saturation vapor pressure in millibars
**********************************************************************/
float
ESAT(t) float t; {	/* Temperature in Kelvin */
    float   esat;

    if (t < 100)
	return (0.);

    esat = pow(10.0, (23.832241 - 5.02808 * log10(t) - 1.3816e-7 *
	pow(10.0, (11.344 -.0303998 * t)) + 8.132801e-3 *
	pow(10.0, (3.49149 - 1302.8844 / t)) - 2949.076 / t));

    return (esat);
    }
