/*
 * Copyright (C) 1990 by the University of Illinois Board of Trustees.
 * 
 * This code is distributed in the hope that it will be useful,
 * but without any warranty.  No author or distributor accepts
 * responsibility to anyone for the consequences of using it or for
 * whether it serves any particular purpose or works at all, unless
 * s/he says so in writing.
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this code under the following conditions:
 * 
 *    Permission is granted to anyone to make or distribute copies
 *    of program source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document, and gives him and points out to
 *    him an exact copy of this document to inform him of his rights.
 * 
 *    Permission is granted to distribute this code in compiled
 *    or executable form under the same conditions applying for
 *    source code, provided that either
 *    A. it is accompanied by the corresponding machine-readable
 *       source code, or
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone.
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code which he received along with it.
 * 
 * In other words, you are welcome to use, share and improve this
 * code.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.   Help stamp out software-hoarding!
 */

/*
 * $Log: sadecode.h,v $
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#define LINESIZE 255
#define MAXOUTLEN 60
#define MISSING_F -9999.
#define MISSING_I -9999

#define MAXLAYERS 5
struct report {
    char id[5];			/* Station id */
    char wmo[6];		/* WMO Station Id if any */
    char sys;			/* E for English, M for metric units */
    int elev;			/* Elevation in meters */
    float lat, lon;		/* Location of station */
    char name[20];		/* Name of station */
    char state[4];		/* State station is in */
    char prio;			/* WMO Priority of station */
    char time[5];		/* Time of report in GMT */
    char ceiltype;		/* W or M or E: how ceiling was measured */
    char ceillayer;		/* Which cloud layer is the ceiling */
    short nlayers;		/* Number of cloud layers */
    char cover[MAXLAYERS];	/* Type of cloud layers */
    short height[MAXLAYERS];	/* Height of cloud layers DIV 100 */
    float vis;			/* Visibility in miles  */
    char wx[10];		/* Weather type code */
    float pmb;			/* Pressure in millibars */
    short temp, dewpt;		/* Temperature in Fahrenheit */
    short wdir, wspd, wgust;	/* Wind direction, speed, and gusts */
    float altimeter;		/* Altimeter setting */
    short wchill;		/* Wind Chill Factor */
    short heat;			/* Heat Index */
    short thi;			/* Temperature-Humidity Index */
    short rh;			/* Relative Humidity */
    char raw[80];		/* The raw SA text */
    int	products;		/* mask of products at station */ 
};

#define FP_MASK		0x1
#define FE_MASK		0x2
#define FQ_MASK		0x4

extern struct report *sadecode();
extern char *wxdecode(), *winddir();

#define FIRST_LOAD	0
#define RELOAD		1
