#include <X11/Intrinsic.h>
#include "sadecode.h"
#include "cache.h"
#include "map.h"
#include "io.h"

#ifdef SYSV_R4
#define char unsigned char
#endif

#include "Bitmaps/torn.bm"
#include "Bitmaps/wndg.bm"
#include "Bitmaps/hail.bm"
#include "Bitmaps/turb.bm"

#ifdef SYSV_R4
#undef char
#endif

#define streq !strcmp

extern void ClearPixmap();
#ifdef X_COPYPLANE_BUG
extern void V_XCopyPlane();
#endif

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */


Pixmap torn = NULL, hail = NULL, turb = NULL, wndg = NULL;

struct serverDataList *curr;
struct serverDataList *selsData;

draw_sels() 
{
    extern double center_lat, center_lon;
    char request[120], *gettoken();
    float rho, ang;
    float lat, lon;
    short x, y;
    struct locs loc;
    int i;

    /*
    ** Request the SELS log data from the server.
    */
    sprintf(request, "PROD SELSLOG\n");
    selsData = getCacheableData(request, "*** No SELS data available");

    if (torn == NULL)
	torn = XCreateBitmapFromData(d, w, torn_bits, torn_width, torn_height);
    if (turb == NULL)
	turb = XCreateBitmapFromData(d, w, turb_bits, turb_width, turb_height);
    if (wndg == NULL)
	wndg = XCreateBitmapFromData(d, w, wndg_bits, wndg_width, wndg_height);
    if (hail == NULL)
	hail = XCreateBitmapFromData(d, w, hail_bits, hail_width, hail_height);

    for (curr = selsData; curr; curr = curr->next) {
	symc = curr->count;
	memcpy(symv, curr->data, sizeof(curr->data));

	if (symv[0][0] == '.') break;

	if (symv[0][0] == '>' || symv[0][0] == '<' || symv[0][0] == '?')
	    continue;
	i = 1;
	if (doonepoint(&i, &loc) == FALSE) continue;
	rho = 1.866*a*tan((90.-loc.lat)*drc/2.);
	ang = (center_lon - loc.lon) * drc;
	x = (short)((rho * sin(ang) - mapleft)*xwa.width/(mapright-mapleft));
	y = (short)((-rho * cos(ang) - maptop)*xwa.height/(mapbottom-maptop));
	if (x < 0 || y < 0 || x > xwa.width || y > xwa.width) continue;

	drawasym(symv[0][0], x, y);
    }
}




static char *slegend[] = {
    "Tornado", "Hail > .75\"", "Svr Turbulence", "Wind Gust >50kt"
    };
static char symindex[] = "TAUW";

draw_sels_legend(bot) 
short *bot; 
{
    int i, x, y, maxtextwidth = 0;
    int maxsymheight = torn_height, maxsymwidth = torn_width;
    XCharStruct cs;
    XFontStruct *f = pref.font[SUBTITLEFONT];
    int sl, dr, fa, fd;
    char *s;

    if (hail_height > maxsymheight) maxsymheight = hail_height;
    if (turb_height > maxsymheight) maxsymheight = turb_height;
    if (wndg_height > maxsymheight) maxsymheight = wndg_height;
    if (f->ascent + f->descent > maxsymheight)
	maxsymheight = f->ascent + f->descent;
    if (hail_width > maxsymwidth) maxsymwidth = hail_width;
    if (turb_width > maxsymwidth) maxsymwidth = turb_width;
    if (wndg_width > maxsymwidth) maxsymwidth = wndg_width;

    XSetFillStyle(d, gc, FillSolid);
    XSetFont(d, gc, f->fid);
    for (i = 0; i < 4; i++) {
	sl = strlen(slegend[i]);
	XTextExtents(f, slegend[i], sl, &dr, &fa, &fd, &cs);
	if (cs.width > maxtextwidth) maxtextwidth = cs.width;
	}
    

    x = 2, y = *bot - 4 * (2 + maxsymheight);
    ClearPixmap(d, w, gc, x, y, maxtextwidth + 5 + maxsymwidth,
	4 * (2 + maxsymheight));

    for (i = 0, y = *bot; i < 4; i++) {
	sl = strlen(slegend[i]);
	XSetForeground(d, gc, pref.pix[DATA]);
	XDrawImageString(d, w, gc, maxsymwidth + 7, y - f->descent,
	    slegend[i], sl);
	drawasym(symindex[i], 2 + maxsymwidth / 2, y - maxsymheight / 2);

	y -= f->ascent + f->descent + 2;
	}

    s = "SELS Legend"; sl = strlen(s);
    y -= f->descent;
    XSetForeground(d, gc, pref.pix[DATA]);
    XTextExtents(f, s, sl, &dr, &fa, &fd, &cs);
    XDrawImageString(d,w, gc, 2 + (maxtextwidth+5+maxsymwidth)/2 - cs.width / 2,
	y, s, sl);

    *bot = y - f->ascent - 10;
}




drawasym(c, x, y) char c; short x, y;
/* Draw a symbol referred to by C (T, W, A, or U), centered on
** the screen location (x,y).
*/ {
    Pixmap symb;
    int symb_height, symb_width;
    int color;

    switch (c) {
	case 'T':
	    symb = torn;
	    symb_width = torn_width;
	    symb_height = torn_height;
	    color = pref.pix[VIP6];
	    break;
	case 'U':
	    symb = turb;
	    symb_width = turb_width;
	    symb_height = turb_height;
	    color = pref.pix[VIP5];
	    break;
	case 'A':
	    symb = hail;
	    symb_width = hail_width;
	    symb_height = hail_height;
	    color = pref.pix[VIP4];
	    break;
	case 'W':
	    symb = wndg;
	    symb_width = wndg_width;
	    symb_height = wndg_height;
	    color = pref.pix[VIP3];
	    break;
	}
    XSetForeground(d, copygc1, color);
#ifdef X_COPYPLANE_BUG
    if (on_root) {
	V_XCopyPlane(d, symb, w, copygc0, 0, 0,
	symb_width, symb_height, x - symb_width / 2,
	y - symb_height / 2, 1);
	V_XCopyPlane(d, symb, w, copygc1, 0, 0,
	symb_width, symb_height, x - symb_width / 2,
	y - symb_height / 2, 1);
	}
    else {
#endif
    XCopyPlane(d, symb, w, copygc0, 0, 0, symb_width, symb_height,
	x - symb_width / 2, y - symb_height / 2, 1);
    XCopyPlane(d, symb, w, copygc1, 0, 0, symb_width, symb_height,
	x - symb_width / 2, y - symb_height / 2, 1);
#ifdef X_COPYPLANE_BUG
    }
#endif
    }
