#define Pixel int 
#include "sadecode.h"
#include "map.h"
#include "cache.h"
#include "io.h"

#define char u_char
#include "Bitmaps/CLR.bm"
#undef char

extern double pi,		/* The value of pi */
      rdc,			/* Degrees to radians conversion */
      drc,			/* Radians to degrees conversion */
      a,			/* Radius of the earth */
      mapleft, mapright,	/* Extents of domain in the x direction */
      maptop, mapbottom;	/* Extents of domain in the y direction */


draw_ua(s) char *s; {
    extern double center_lat, center_lon;
    extern Pixmap CLR_symb, OVC_symb;
    Pixmap stn_symb;
    FILE *rfd, *wfd = NULL;
    char buf[120];
    float rho, ang;
    float lat, lon;
    float temp, dpdp;
    double round();
    char level = s[1];
    int dir, vel, ht;
    int i, sl, dr, fa, fd;
    XCharStruct cs;
    short x, y;
    struct serverDataList *isoData;

    /*
    ** Request the isobar data from the server.
    */
    sprintf(buf, "%s %s\n", s, upperairtime);
    isoData = getCacheableData(buf, "*** Isometric data not available");

    XSetForeground(d, gc, pref.pix[DATA]);
    XSetForeground(d, copygc1, pref.pix[DATA]);
    XSetFont(d, gc, pref.font[DATAFONT]->fid);

    for (; isoData; isoData = isoData->next) {
	symc = isoData->count;
	memcpy(symv, isoData->data, sizeof(isoData->data));

	if (symv[0][0] == '.') break;

	if (symc != 8) continue;


	lat = atof(symv[1]); lon = atof(symv[2]);
	if (lat < 0.0) continue;
	temp = round(atof(symv[4])); dpdp = round(atof(symv[5]));
	dir = atoi(symv[6]); vel = atoi(symv[7]);
	ht = atoi(symv[3]);

	rho = 1.866*a*tan((90.-lat)*drc/2.);
	ang = (center_lon - lon) * drc;
	x = (short)((rho * sin(ang) - mapleft) * xwa.width/(mapright-mapleft));
	y = (short)((-rho * cos(ang) - maptop) * xwa.height/(mapbottom-maptop));
	if (x < 0 || y < 0 || x > xwa.width || y > xwa.height) continue;


	/*
	** Draw center symbol. Filled circle if dewpoint depression
	** is <= 5, open circle otherwise.
	*/
	if (dpdp == MISSING_F || dpdp > 5.0) stn_symb = CLR_symb;
	else stn_symb = OVC_symb;
#ifdef X_COPYPLANE_BUG
        if (on_root) {
            V_XCopyPlane(d, stn_symb, w, copygc0, 0,0, CLR_width,CLR_height,
               x-5,y-5, 1);
            V_XCopyPlane(d, stn_symb, w, copygc1, 0,0, CLR_width,CLR_height,
               x-5,y-5, 1);
            }
        else
#endif
        XCopyPlane(d, stn_symb, w, copygc0,0,0,CLR_width,CLR_height,x-5,y-5,1);
        XCopyPlane(d, stn_symb, w, copygc1,0,0,CLR_width,CLR_height,x-5,y-5,1);

	/*
	** Draw temperature and dewpoint depression.
	*/
	if (temp != MISSING_F) {
	    sprintf(buf, "%d", (int)temp);
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x-4-cs.width, y-5, buf, sl);
	    }

	if (temp >= -41.0 && dpdp != MISSING_F) {
	    if (dpdp > 29.) strcpy(buf, "X");
	    else sprintf(buf, "%d", (int)dpdp);
	    sl = strlen(buf);
	    XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	    XDrawString(d, w, gc, x-4-cs.width, y+5+cs.ascent, buf, sl);
	    }
	
	/*
	** Draw height. First convert into three-digit form.
	*/
	switch (level) {
	    case '8': ht -= 1000; break;
	    case '7': ht -= 2000; if (ht >= 1000) ht -= 1000; break;
	    case '2': ht -= 10000;  /* and fall through to... */
	    default:  ht /= 10;
	    }
	sprintf(buf, "%03d", ht);
	sl = strlen(buf);
	XTextExtents(pref.font[DATAFONT], buf, sl, &dr, &fa, &fd, &cs);
	XDrawString(d, w, gc, x+3, y-5, buf, sl);

	/*
	** Draw wind barb.
	*/
	if (dir == MISSING_I || vel == MISSING_I || dir > 360 || vel > 200)
	    XDrawString(d, w, gc, x+4, y+5+cs.ascent, "M", 1);
	else draw_wind(dir + (int)(lon - center_lon), vel, x, y);
    }
}



double
round(x) double x; {
    
    if (x > 0) return (double)(int)(x + 0.5);
    else return (double)(int)(x - 0.5);
    }
