/*
 *
 *		    Copyright (c) 1991
 *		    Jeff Hollingsworth
 *
 *  Permission to use, copy, modify, and distribute this
 *  software and its documentation for any purpose and without
 *  fee is hereby granted, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting
 *  documentation, and that the name of principal(s) not be used
 *  in any advertising or publicity relating to this software
 *  without specific, written prior authorization.  No representations
 *  are made about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "@(#) $Header: /home/poona/hollings/src/original/xweather/RCS/widgets.c,v 1.11 1992/12/17 17:40:40 hollings Exp $";
#endif

/*
 * $Log: widgets.c,v $
 * Revision 1.11  1992/12/17  17:40:40  hollings
 * fixed type of 3rd arf to XtAddEventHandler.
 *
 * Revision 1.10  1992/12/17  01:17:20  hollings
 * SYSV port.
 *
 * Revision 1.9  1992/12/16  19:41:56  hollings
 * fix to extern help_window to make it work with more compilers.
 *
 * Revision 1.8  1992/12/16  19:24:33  hollings
 * fixes to compile with gcc.
 *
 * Revision 1.7  1992/11/25  19:35:00  hollings
 * removed obsolete product Extended Forcast.
 *
 * Revision 1.6  1992/08/27  15:13:56  hollings
 * added Earth Quake Summary
 *
 * Revision 1.5  1992/07/02  19:39:23  hollings
 * Color codeded watch boxes.
 *
 * Revision 1.4  1992/05/05  23:27:40  hollings
 * Version 1.0.
 *
 * Revision 1.3  1992/04/24  20:45:46  hollings
 * user preferences.
 *
 * Revision 1.2  1992/01/22  20:43:43  hollings
 * vPanedWidgetClass->panedWidgetClass for R5.
 *
 * Revision 1.1  1991/12/10  16:51:29  hollings
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>

#define extern
#include "windows.h"
#undef extern
#include "map.h"

#define char u_char
#include "check.xbm"
#include "wxmap_icon.h"
#undef char

#include "rubberband.h"

XtAccelerators *acc;

String accelerator = "#override\n\
    <Key>Return: set() notify() unset()";

static	Arg	help_args[] = {
    { XtNlabel,		(XtArgVal) " "},
};

static XSizeHints mapSizeHints = {
    PAspect | PMinSize,
    100, 100,                           /* X, Y */
    950, 800,                           /* Default width, height */
    285, 240,                           /* Minimum size */
    0, 0,                               /* Maximum size (not set) */
    0, 0,                               /* Size increments (not set) */
    19, 16, 19, 16,                     /* Aspect ratio */
};

static rubber_band_data data;

extern void	help_window();
extern Window xwin;
Widget help_widget;
extern Widget top;
Pixmap icon_pixmap;
void XtSetValue();

String mapTransString = 
  "<Btn1Down>: XawPositionSimpleMenu(pointProductMenu) \
	       MenuPopup(pointProductMenu)";

/*
 * Build framework for map.
 *
 */
buildWidgets(top)
Widget top;
{
    int ret;
    int acount;
    Arg args[100];
    int x, y, width, height;
    XSetWindowAttributes xswa;
    XtTranslations mapTranslations;
    extern void resize_handler(), button_release();
    extern void redraw_handler(), track_rubber_band();
    extern void button_handler(), key_press_handler();

    info.pane = XtCreateManagedWidget("vpane", panedWidgetClass, top, 
	NULL, 0);

    acount = 0;
    XtSetArg(args[acount], XtNfont, pref.font[TITLEFONT]); acount++;
    XtSetArg(args[acount], XtNlabel, title); acount++;
    info.TB = XtCreateManagedWidget("TitleBar", 
	labelWidgetClass, info.pane, args, acount);

    info.box = XtCreateManagedWidget("buttons", boxWidgetClass, 
	info.pane, 0, 0);

    acount = 0;
    XtSetArg(args[acount], XtNallowVert, (XtArgVal) True); acount++;
    XtSetArg(args[acount], XtNforceBars, True); acount++;
    XtSetArg(args[acount], XtNheight, (XtArgVal) 80); acount++;
    XtSetArg(args[acount], XtNmax, (XtArgVal) 80); acount++;
    info.port = XtCreateManagedWidget("port", viewportWidgetClass,
	info.pane, args, acount);
	
    acount = 0;
    XtSetArg(args[acount], XtNlist, note); acount++;
    XtSetArg(args[acount], XtNnumberStrings, nnotes); acount++;
    XtSetArg(args[acount], XtNdefaultColumns, 1); acount++;
    XtSetArg(args[acount], XtNforceColumns, True); acount++;
    XtSetArg(args[acount], XtNfont, pref.font[SUBTITLEFONT]); acount++;
    /* test */
    XtSetArg(args[acount], XtNheight, 24); acount++;
    info.notes = XtCreateManagedWidget("notes", listWidgetClass, 
	info.port, args, acount);
    XtAddEventHandler(info.notes, EnterWindowMask, 0, (XtEventHandler) 
	help_window,  "Severe Weather Watches and Warnings");
    XtAddEventHandler(info.notes, LeaveWindowMask, 0, 
	(XtEventHandler) help_window,  " ");

    info.help = XtCreateManagedWidget("Help Window", labelWidgetClass, 
	info.pane, help_args, XtNumber(help_args));
    help_widget = info.help;
    XtAddEventHandler(info.help, EnterWindowMask, 0, 
	(XtEventHandler) help_window, (caddr_t) " ");
    XtAddEventHandler(info.help, LeaveWindowMask, 0, 
	(XtEventHandler) help_window, (caddr_t) " ");

    acount = 0;
    mapTranslations = XtParseTranslationTable(mapTransString);
    XtSetArg(args[acount], XtNwidth, 950); acount++;
    XtSetArg(args[acount], XtNheight, 646); acount++;
    XtSetArg(args[acount], XtNtranslations, mapTranslations); acount++;
    info.map = XtCreateManagedWidget("Map", simpleWidgetClass, info.pane,
        args, acount);
    initRubberBand(info.map, &data, pref.pix[DATA], pref.pix[BG]);
    XtAddEventHandler(info.map, ExposureMask, False, redraw_handler, (caddr_t)
	info.map);
    XtAddEventHandler(info.map, ButtonPressMask, False, button_handler, 
	(caddr_t) &data);
    XtAddEventHandler(info.map, ButtonReleaseMask, False, button_release, 
	(caddr_t) &data);
    XtAddEventHandler(info.map, ButtonMotionMask, False, 
	track_rubber_band, &data);
    XtAddEventHandler(info.map, StructureNotifyMask, False, resize_handler, 
	(caddr_t) info.map);
    buildPointProductMenu();

    /* Create pixmap for check sign. Must be done before menu is built is
     *   ready_buttons. 
     */
    check_pixmap = XCreateBitmapFromData(d, RootWindowOfScreen(XtScreen(top)), 
	check_bits, check_width, check_height);

    /*
     * Create main icon.
     *
     */
    icon_pixmap = XCreateBitmapFromData(d, RootWindowOfScreen(XtScreen(top)),
	wxmap_icon_bits, wxmap_icon_width, wxmap_icon_height);
    
    ready_buttons(&info);

    XtRealizeWidget(top);
    xwin = XtWindow(info.map);
    w = xwin;

    /* get the geometry data */
    ret = XParseGeometry(pref.geometry, &x, &y, &width, &height);
    if ((ret & XValue) && (ret & YValue)) {
	mapSizeHints.x = x;
	mapSizeHints.y = y;
	mapSizeHints.flags |= USPosition;
    }
    XSetNormalHints(d, XtWindow(top), &mapSizeHints);
    xswa.cursor = watch;
    xswa.event_mask = ExposureMask;
    xswa.background_pixel = pref.pix[BG];
    xswa.border_pixel = pref.pix[BORDER];
    xswa.override_redirect = False;
    xswa.backing_store = WhenMapped;
    xswa.backing_planes = AllPlanes;
    /* Fix this */
    XChangeWindowAttributes(d, XtWindow(top), False, &xswa);
    XGetWindowAttributes(d, xwin, &xwa);

}

extern void refetch_func(), quit_func(), change_func();
extern void display_func(), pref_func();
extern void helpWindow();
extern void help_func();
extern void region_func();
extern void station_func();
extern void full_func();

#define BUTTON	1
#define MENU	2
#define CHANGE_BUTTON	0
#define HEIGHT_BUTTON	2
#define REGION_BUTTON	4
#define PRIORITY_BUTTON	5
#define SUMMARY_BUTTON	7

static  struct  {
	int 	type;
	char    *name;
	void    (*func)();
	char	*menuName;
	char    *desc;
} buttons[] = {
    { BUTTON,	"Change", 	change_func, 		NULL,
        "Change the displayed data" },
    { BUTTON,	"Full Map",	full_func, 		NULL,
        "Display Data for the entire Continental United States" },
    { MENU,	"Height",	NULL, 		"heightMenu",
        "Surface or Upper Air Data" },
    { BUTTON,	"Redraw",	display_func, 		NULL,
        "Redraw the map" },
    { MENU,	"Regional Maps",NULL, 			"regionMenu",
        "Display Data for a Region of the country" },
    { MENU,	"Station Priority", NULL, 		"priorityMenu",
        "Set the threshold for number of stations displayed" },
    { BUTTON,	"Station Report",   station_func, 	NULL,
        "Display Report for a Particular Weather Station" },
    { MENU,	"Summary",	NULL, 			"summaryMenu",
	"National Weather Summary and Seven, Ten, Thirty and 90 Day Outlooks" },
    { BUTTON,	"Reload Data",   refetch_func, 	NULL,
        "Reload data from server" },
    { BUTTON,	"Preferences", 	pref_func, 		NULL,
        "Define user display preferences" },
    { BUTTON, 	"Help", 	help_func,      	NULL,
        "Display Manual Page" },
    { BUTTON, 	"Quit", 	quit_func,      	NULL,
        "Quit program" },
};

struct menuStuff {
    char *name;
    int data;
}; 

struct menuStuff displayMenuData[] = {
 { "Automated Radar Summary",		(int) SHO_ARS },
 { "Clouds",				(int) SHO_CLD },
 { "Dew Point",				(int) SHO_DEWP },
 { "Fronts",				(int) SHO_FRONT },
 { "ISO-Bars",				(int) SHO_ISOBAR },
 { "ISO-Dew Point",			(int) SHO_ISODROSO },
 { "ISO-Therms",			(int) SHO_ISOTHERM },
 { "Pressure",				(int) SHO_PRES },
 { "Radar Summary",			(int) SHO_RADSUM },
 { "Regions",				(int) SHO_REGION },
 { "Station Name",			(int) SHO_NAME },
 { "Temperature",			(int) SHO_TEMP },
 { "Visibility",			(int) SHO_VIS },
 { "Watches",				(int) SHO_WATCH },
 { "Wind",				(int) SHO_WIND },
 { "Yesterday's Severe Weather Reports",		(int) SHO_SELS },
 { "Weather Symbols",			(int) SHO_WX },
};

struct menuStuff heightMenu[] = {
 { "Surface",		(int) 0 },
 { "850 mili-bars",	(int) 8 },
 { "700 mili-bars",	(int) 7 },
 { "500 mili-bars",	(int) 5 },
 { "300 mili-bars",	(int) 3 },
 { "200 mili-bars",	(int) 2 },
};


struct menuStuff regionalMenu[] = {
 { "Atlantic States",		(int) REGION_AT },
 { "Midwest", 			(int) REGION_MW },
 { "New England",		(int) REGION_NE },
 { "Northwestern States", 	(int) REGION_NW },
 { "Southeastern States", 	(int) REGION_SE },
 { "Southern Plains States", 	(int) REGION_SP },
 { "Southwestern States", 	(int) REGION_SW },
};

struct menuStuff priorityMenu[] = {
 { "Major Stations",		(int) 1 },
 { "Up to Level 2",		(int) 2 }, 
 { "Up to Level 3",		(int) 3 }, 
 { "Up to Level 4",		(int) 4 }, 
 { "All Stations",		(int) 5 },
};

struct menuStuff summaryMenu[] = {
 {  "National Weather Summary",		(int) "ABUS1-KWBC" },
 {  "Earth Quake Summary",		(int) "SEXX2-KWBC" },
 {  "Seven Day Temperature Forecast",	(int) "FEUS50-KWBC" },
 {  "Ten Day Outlook",			(int) "FEUS40-KWBC" },
 {  "Thirty Day Outlook",		(int) "FPUS6-KWBC" },
 {  "Ninety Day Outlook",		(int) "FEUS9-KWBC" },
};

struct menuStuff pointProductMenu[] = {
    { "Current Conditions",     (int) "CurrentConditions" },
    { "Climatological Rpt",     (int) "csus2" },
    { "Local Fcst",             (int) "fxus21" },
    { "Zone Fcst",             	(int) "fpus5" },
    { "Road Conditions",        (int) "sxus90" },
    { "Special Stmts",          (int) "wwus35" },
    { "State Fct",              (int) "fpus1" },
};

buildMenu(parent, menuTitle, menuName, menuData, count, handlerFunc, hasCheck, highLightedData, menuWidget)
Widget parent;
char *menuTitle;
char *menuName;
struct menuStuff menuData[];
int count;
int hasCheck;
int highLightedData;
void (*handlerFunc)();
Widget menuWidget[];
{
    int i;
    int acount;
    Widget menu;
    Widget entry;
    Arg arg[100];

    acount = 0;
    XtSetArg(arg[acount], XtNlabel, menuTitle); acount++;
    menu = XtCreatePopupShell(menuName, simpleMenuWidgetClass, 
	parent, arg, acount);

    for (i=0; i < count; i++) {
	acount = 0;
	XtSetArg(arg[acount], XtNlabel, menuData[i].name); acount++;
	if (hasCheck) {
	    XtSetArg(arg[acount], XtNleftMargin, check_width + 4); acount++;
	    if (highLightedData == (int) menuData[i].data) {
		/* Set check mark */
		XtSetArg(arg[acount], XtNleftBitmap, check_pixmap); acount++;
	    }
	}
	entry = XtCreateManagedWidget(menuData[i].name, 
	    smeBSBObjectClass, menu, arg, acount);
	if (menuWidget) menuWidget[i] = entry;

	XtAddCallback(entry, XtNcallback, (XtCallbackProc) handlerFunc, 
	    (XtPointer) menuData[i].data);
    }
}

ready_buttons(info)
Info *info;
{
    int i;
    int acount;
    Arg arg[100];
    Widget menu, entry;
    extern int SetHeight();
    extern int ShowRegion();
    extern Widget add_button();
    extern int DisplaySummary();
    extern int ChangePriority();

    info->buttons = (Widget *) calloc(sizeof(Widget), XtNumber(buttons));
    for (i = 0; i < XtNumber(buttons); i++) {
	if (buttons[i].type == BUTTON) {
	    info->buttons[i] = add_button(info->box, buttons[i].name,
		buttons[i].func, buttons[i].desc);
	} else {
	    acount = 0;
	    XtSetArg(arg[acount], XtNshapeStyle, XawShapeOval); acount++;
	    XtSetArg(arg[acount], XtNmenuName, buttons[i].menuName); acount++;
	    info->buttons[i] = XtCreateManagedWidget(buttons[i].name,
		menuButtonWidgetClass, info->box, arg, acount);
	    XtAddEventHandler(info->buttons[i], EnterWindowMask, 0, 
		(XtEventHandler) help_window, (caddr_t) buttons[i].desc);
	    XtAddEventHandler(info->buttons[i], LeaveWindowMask, 0, 
		(XtEventHandler) help_window, (caddr_t) " ");
	}
    }

    /*
     * Build Height option.
     */
    buildMenu(info->buttons[HEIGHT_BUTTON], "Height", "heightMenu", heightMenu,
	XtNumber(heightMenu), SetHeight, TRUE, pref.height, heightWidgets);

    /*
     * Build Regional options.
     *
     */
    buildMenu(info->buttons[REGION_BUTTON], "Regions", "regionMenu", 
	regionalMenu, XtNumber(regionalMenu), ShowRegion, FALSE, NULL, NULL);

    /*
     * Priority.
     *
     */
    buildMenu(info->buttons[PRIORITY_BUTTON], "Station Threshold", 
	"priorityMenu", priorityMenu, XtNumber(priorityMenu), 
	ChangePriority, TRUE, maxprio, priorityWidgets);

    /*
     * Long term.
     *
     */
    buildMenu(info->buttons[SUMMARY_BUTTON], "National Products", 
	"summaryMenu", summaryMenu, XtNumber(summaryMenu), 
	DisplaySummary, FALSE, NULL, NULL);
}

buildPointProductMenu()
{
    int i;
    int acount;
    Arg arg[50];
    Widget entry;
    extern void pointProductCallBack();

    acount = 0;
    XtSetArg(arg[acount], XtNlabel, "Products"); acount++;
    info.mapMenu = XtCreatePopupShell("pointProductMenu", 
	simpleMenuWidgetClass, info.map, arg, acount);

    for (i=0; i < XtNumber(pointProductMenu); i++) {
	acount = 0;
	XtSetArg(arg[acount], XtNlabel, pointProductMenu[i].name); acount++;
	entry = XtCreateManagedWidget(pointProductMenu[i].name, 
	    smeBSBObjectClass, info.mapMenu, arg, acount);
	XtAddCallback(entry, XtNcallback, (XtCallbackProc) 
	    pointProductCallBack, (XtPointer) pointProductMenu[i].data);
    }
    info.mapMenuLabel = XtNameToWidget(info.mapMenu, "menuLabel");
    if (!info.mapMenuLabel) {
	printf("label not found\n");
    }
}

static  XtCallbackRec   button_callbacks[] = {
        {(XtCallbackProc) 0,    (caddr_t) 0},
        {(XtCallbackProc) 0,    (caddr_t) 0},
};

static  Arg             button_args[] = {
        {XtNcallback,   (XtArgVal) button_callbacks},
        {XtNshapeStyle, (XtArgVal) XawShapeOval},
};

Widget add_button(box, name, func, desc)
Widget  box;
char    *name;
void    (*func)();
char    *desc;
{
    Widget      w;
    extern      void    help_window();

    button_callbacks[0].callback = func;
    w = XtCreateManagedWidget(name, commandWidgetClass, box,
	button_args, XtNumber(button_args));

    XtAddEventHandler(w, EnterWindowMask, 0, help_window, (caddr_t) desc);
    XtAddEventHandler(w, LeaveWindowMask, 0, help_window, (caddr_t) " ");

    return(w);
}

/* The X tool kit should have had this function defined  */
void XtSetValue(widget, field, result)
Widget widget;
char *field;
caddr_t result;
{
    Arg AList[1];

    XtSetArg(AList[0], field, result);
    XtSetValues(widget, AList, 1);
}

char stationName[80];

struct dispOption {
    char *name;
    char *product;
}; 

CreateDisplayPopup()
{
    int i;
    int dummy;
    int x, y;
    int acount;
    Arg args[80];
    XSizeHints hints;
    Widget tw, dw, pw;
    extern int ToggleDisplayItem();
    extern int ChangeDisplayCallBack();

    if (info.displaySheet) return;

    XGetGeometry(d, XtWindow(info.pane), (Window *) &dummy, 
	&x, &y, &dummy,&dummy,&dummy,&dummy);
    acount = 0;
    XtSetArg(args[acount], XtNsaveUnder, True); acount++;
    XtSetArg(args[acount], XtNx, 10); acount++;
    XtSetArg(args[acount], XtNy, 10); acount++;
    XtSetArg(args[acount], XtNiconPixmap, icon_pixmap); acount++;
    info.displaySheet = XtCreatePopupShell("Display Options", 
	topLevelShellWidgetClass, info.pane, args, acount);
    
    acount = 0;
    XtSetArg(args[acount], XtNborderWidth, 25); acount++;
    dw = XtCreateManagedWidget("Options", formWidgetClass,
	info.displaySheet, args, acount);

    acount = 0;
    XtSetArg(args[acount], XtNy, 5); acount++;
    XtSetArg(args[acount], XtNwidth, 250); acount++;
    XtSetArg(args[acount], XtNlabel, "Display Options"); acount++;
    XtSetArg(args[acount], XtNfont, pref.font[TITLEFONT]); acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    XtSetArg(args[acount], XtNjustify, XtJustifyCenter); acount++;
    tw = XtCreateManagedWidget("title", labelWidgetClass, dw, args, acount);

    for (i=0; i < XtNumber(displayMenuData); i++) {
	acount = 0;
	XtSetArg(args[acount], XtNfromVert, tw); acount++;
	XtSetArg(args[acount], XtNborderWidth, 0); acount++;
	XtSetArg(args[acount], XtNvertDistance, 1); acount++;
	XtSetArg(args[acount], XtNlabel, displayMenuData[i].name); acount++;
	XtSetArg(args[acount], XtNjustify, XtJustifyLeft); acount++;
	XtSetArg(args[acount], XtNwidth, 250); acount++;
	if (pref.disp_list[displayMenuData[i].data]) {
	    XtSetArg(args[acount], XtNstate, True); acount++;
	}
	tw = XtCreateManagedWidget("option", toggleWidgetClass, dw, args, 
	    acount);
	XtAddCallback(tw,XtNcallback, (XtCallbackProc) ToggleDisplayItem,
	    (XtPointer) displayMenuData[i].data);
    }

    acount = 0;
    XtSetArg(args[acount], XtNhorizDistance, 50); acount++;
    XtSetArg(args[acount], XtNfromVert, tw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Accept", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, (XtCallbackProc) ChangeDisplayCallBack, 
	(XtPointer) 1);

    acount = 0;
    XtSetArg(args[acount], XtNfromVert, tw); acount++;
    XtSetArg(args[acount], XtNfromHoriz, pw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNhorizDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Cancel", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, (XtCallbackProc) ChangeDisplayCallBack, 
	(XtPointer) 0);

    XtRealizeWidget(info.displaySheet);
    hints.x = 50;
    hints.y = 50;
    hints.flags = USPosition;
    XSetNormalHints(d, XtWindow(info.displaySheet), &hints);
}

struct dispOption productList[] = {
    { "Current Conditions",	"CurrentConditions" },
    { "Local Fcst",		"fqus1" },
    { "State Fct",  		"fpus1" },
 /* { "Radar Summary",		"sdxx1" }, */
 /* { "River Report", 	"rwus21" }, */
 /* { "Extended Forcast",	"feus1" }, */
    { "Special Stmts",		"wwus35" },
};

CreateStationInfoPopup()
{
    int i;
    int acount;
    Arg args[80];
    XSizeHints hints;
    Widget stn, tw, dw, pw;
    extern int DisplayStationCallBack();

    if (info.dialog) return;

    acount = 0;
    XtSetArg(args[acount], XtNsaveUnder, True); acount++;
    XtSetArg(args[acount], XtNx, (xwa.width - 450)/2); acount++;
    XtSetArg(args[acount], XtNy, (xwa.height - 250)/2 + 50); acount++;
    XtSetArg(args[acount], XtNiconPixmap, icon_pixmap); acount++;
    info.dialog = XtCreatePopupShell("Stn Info", topLevelShellWidgetClass,
	info.pane, args, acount);
    
    acount = 0;
    XtSetArg(args[acount], XtNborderWidth, 25); acount++;
    dw = XtCreateManagedWidget("Print Options", formWidgetClass,
	info.dialog, args, acount);

    acount = 0;
    XtSetArg(args[acount], XtNy, 5); acount++;
    XtSetArg(args[acount], XtNlabel, "Station Report"); acount++;
    XtSetArg(args[acount], XtNfont, pref.font[TITLEFONT]); acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    tw = XtCreateManagedWidget("title", labelWidgetClass, dw, args, acount);

    acount = 0;
    XtSetArg(args[acount], XtNfromVert, tw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 15); acount++;
    XtSetArg(args[acount], XtNlabel,"Station Name or Product Request");acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    tw = XtCreateManagedWidget("title", labelWidgetClass, dw, args, acount);

    acount = 0;
    XtSetArg(args[acount], XtNlength, 80); acount++;
    XtSetArg(args[acount], XtNwidth, 300); acount++;
    XtSetArg(args[acount], XtNfromVert, tw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 5); acount++;
    XtSetArg(args[acount], XtNtype, XawAsciiString); acount++;
    strcpy(stationName, "Madison");
    XtSetArg(args[acount], XtNstring, stationName); acount++;
    XtSetArg(args[acount], XtNeditType, XawtextEdit); acount++;
    XtSetArg(args[acount], XtNuseStringInPlace, True); acount++;
    stn = tw = XtCreateManagedWidget("Text", asciiTextWidgetClass, 
	dw, args, acount);

    /*
     * Product list.
     */
    acount = 0;
    XtSetArg(args[acount], XtNfromVert, tw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 15); acount++;
    XtSetArg(args[acount], XtNlabel, "Report Type"); acount++;
    XtSetArg(args[acount], XtNborderWidth, 0); acount++;
    tw = XtCreateManagedWidget("title", labelWidgetClass, dw, args, acount);

    info.toggle = NULL;
    for (i=0; i < XtNumber(productList); i++) {
	acount = 0;
	XtSetArg(args[acount], XtNfromVert, tw); acount++;
	XtSetArg(args[acount], XtNfromHoriz, info.toggle); acount++;
	XtSetArg(args[acount], XtNvertDistance, 10); acount++;
	XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
	XtSetArg(args[acount], XtNlabel, productList[i].name); acount++;
	XtSetArg(args[acount], XtNradioGroup, info.toggle); acount++;
	XtSetArg(args[acount], XtNradioData, productList[i].product); acount++;
	if (i==0) {
	    XtSetArg(args[acount], XtNstate, True); acount++;
	}
	info.toggle = XtCreateManagedWidget("option", toggleWidgetClass, dw, 
	    args, acount);
    }

    acount = 0;
    XtSetArg(args[acount], XtNaccelerators, 
        XtParseAcceleratorTable(accelerator)); acount++;
    XtSetArg(args[acount], XtNhorizDistance, 175); acount++;
    XtSetArg(args[acount], XtNfromVert, info.toggle); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Display", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, (XtCallbackProc) DisplayStationCallBack, 
	(XtPointer) 1);
    XtInstallAccelerators(stn, pw);

    acount = 0;
    XtSetArg(args[acount], XtNfromVert, info.toggle); acount++;
    XtSetArg(args[acount], XtNfromHoriz, pw); acount++;
    XtSetArg(args[acount], XtNvertDistance, 25); acount++;
    XtSetArg(args[acount], XtNhorizDistance, 25); acount++;
    XtSetArg(args[acount], XtNshapeStyle, XawShapeOval); acount++;
    pw = XtCreateManagedWidget("Cancel", commandWidgetClass, dw, args, acount);
    XtAddCallback(pw, XtNcallback, (XtCallbackProc) DisplayStationCallBack, 
	(XtPointer) 0);

    XtRealizeWidget(info.dialog);
    hints.x = xwa.width/2;
    hints.y = xwa.height/2;
    hints.flags = USPosition;
    XSetNormalHints(d, XtWindow(info.dialog), &hints);
}

