.TH XWEATHER 1L LOCAL
.wh 0 
.pl 76i 
.SH NAME
xweather \- weather disseminator
.SH SYNOPSIS
.B xweather
[\-option ...]
.SH DESCRIPTION
.PP
\fIXweather\fP is an X tool for producing graphical weather maps on an X
workstation. 
Don't let the size of this manual page intimidate you, \fIxweather\fP is
a very easy program to use.
.PP
The maps display the current weather conditions, current being defined
as less than two hours old. If the last report from a station was
received more than two hours ago, that report will not be used in
generating the maps. You can also display radar information from the
National Radar Summary, severe weather outlook regions, severe weather
watch boxes, isobars (lines of constant barometric pressure),
and the current estimates of where highs, lows, and fronts are
located. If you're in a silly mood, you can request all this at once,
and the resulting incredibly colorful and crowded map looks really
interesting.
.PP
The weather data used is loaded over CICnet from a server at UIUC.
The current conditions
database is updated every half hour at :10 and :40; the radar summary
database is updated every hour at :10. The date and time of the
database being used is displayed when \fIxweather\fP starts up and also appears
on every map drawn. 
By default, \fIxweather\fP updates the data every hour at a random time between
10 and 15 min. after the hour (this is to prevent putting a large load on the
server).
.PP
Once \fIxweather\fP is running, you use the buttons at the top of the 
display window to control the information you want to see.
In addition, the mouse buttons can be used over the map.
The left mouse button causes the current conditions for the nearest displayed
station to be displayed in the text window just above the map.
In addition, a pulldown menu is displayed that lets you select products to
be displayed.
The middle button is used to zoom in on the map.
To zoom, hold the middle button down and drag it over the region to be 
displayed, and release the button to select the region.
Pressing the right button causes the point where the mouse button was pressed
to become the center of the map.
.SH COMMAND BUTTONS
.PP
The available buttons are described below:
.PP
.B Change
.IP
produces a popup menu to control the information currently displayed on the
map.
Each line in the menu can be highlighted (indicating the item should be 
displayed on the map).
When you are done selecting the items for display, press the accept button at
the bottom of the menu to update the map.
.TP 10
.ti +.5i
.B Automated Radar Summary
Show the Automated Radar Summary, which is both the
above echo intensity display plus maximum top figures,
movement arrows, and plotted comments. 
Watches are also also displayed.
The format of this display is meant to be very similar
to that of the NWS Automated Radar Summary chart.
.TP 10
.ti +.5i
.B Clouds
Show sky-and-ceiling symbols centered on the location
of the station.
.TP 10
.ti +.5i
.B Dew Point
Show station dew point on the left hand side
of the station symbol.
.TP 10
.ti +.5i
.B Fronts
Draw cold, warm, stationary, and occluded fronts and
(sometimes) high and low pressure centers. The type
of front is given by its color or dash pattern, and
there really should be a legend for this, but there
isn't yet. 
.TP 10
.ti +.5i
.B ISO-Bars
Draw isobars. These are lines of constant
pressure, and are determined from the sea-level
pressures of selected stations.
.TP 10
.ti +.5i
.B ISO-Dew Point
Draw isodrosotherms. These are lines of constant dewpoint
and are useful in forecasting some types of severe storms.
.TP 10
.ti +.5i
.B ISO-Therms
Draw isotherms. These are lines of constant temperature.
.TP 10
.ti +.5i
.B Pressure
Show barometric pressure on the right hand side
of the station symbol.
.TP 10
.ti +.5i
.B Radar Summary
Show the National Radar Summary data. This works best
on a color display but is useful in mono-chrome as
well. The echo intensity reports for all radar
reporting stations in the country are coalesced into
one grid which is then contoured into polygons of
different color/shading.
.TP 10
.ti +.5i
.B Regions
Show regions defined by the DEFREGION command.
Typically these regions will be defined for you by
the data loaded from the network, and will be
explained by a note typed out after the database
is loaded.
.TP 10
.ti +.5i
.B Station Names
Show station ids centered on the location of the
station instead of the cloud symbol. Useful if your
geography is bad and/or you're not particularly
interested in sky-and-ceiling data.
.TP 10
.ti +.5i
.B Temperature
Show station temperature on the left hand side
of the station symbol.
.TP 10
.ti +.5i
.B Visibility
Show the station visibility only. Only actually
useful if this is the only display requested.
.TP 10
.ti +.5i
.B Watches
Show the current severe weather watch boxes defined by
the WATCH command. Typically these watch boxes will be
defined for you by the data loaded from the network,
and explained by a note typed out after the database
is loaded.
.TP 10
.ti +.5i
.B Wind
Show the wind barb. Wind barbs point into the wind
and have a number of flags proportional to the wind
velocity: full flags count for ten knots, half flags
count for five knots.
.TP 10
.ti +.5i
.B Weather Symbols
Show the weather symbol and visibility figure to the
left of the station symbol.
.PP
.B Full Map
.IP
displays the map for the entire continental United States.
It also resets the station priority to level 2.
.PP
.B Height
.IP
Set the height of the data being displayed.
The default is surface data.  Various upper air values are also available.
.PP
.B Redraw
.IP
refreshes the map. None of the display parameters are changed.
.PP
.B Regional Maps
.IP
produces a pull down menu that lets you select one of seven regional maps for
display.
.PP
.B Station Priority
.IP
lets you control the number of stations being displayed on the map.
Every station in the country is assigned a priority from 1 (most important) to
5 (least important).
Setting the station priority indicates that all stations at the selected
priority and any higher priorities will be displayed.
.PP
.B Station Report
.IP
produces a popup dialog box that permits textual reports for individual weather
stations to be displayed.
There are five major types of reports: Current Conditions, Local Forecast, State
Forecast, Extended Forecast (3-5 days), and Special Statements (severe weather
alerts).
To select a report, press the button for the that report on the station 
popup.
To select a station, enter either the station code (e.g. MSN, LAX) or the
name of the station (e.g. Madison) in the Station Name text area.
.IP
In addition, you can enter a NWS product code in the station name box (it must
contain a "-").
This is an advanced feature and if you don't know what NWS product codes are
don't worry about it.
.PP
.B Summary
.IP
Display text based products that relate to whole nation, not just a single
weather station.
.PP
.B Reload Data
.IP
Get fresh data from the weather server.
\fIXweather\fP caches most of the data it uses, and this command will cause
the program to flush its cache and re-fetch the data.
.PP
.B Preferences
.IP
Display a popup menu to select user defined display preferences.
.TP 10
.ti +.5i
.B Conditions
Controls how the current conditions are displayed in the help window when the
mouse is pressed over a selected city.
The default is \fBParsed\fP which presents a condensed version of the 
current conditions popup.
\fBRaw\fP format is meaningful to pilot and others 
who understand NWS abbreviate.
.TP 10
.ti +.5i
.B Timezone
Controls what timezone is used.  The default is \fBLocal\fP, but some people
prefer \fBUTC\fP (aka Zulu or Greenwich Mean Time).
.TP 10
.ti +.5i
.B Legend
Controls if the Front and Echo Intensities legends are displayed.
The default is \fBVisible\fP.
\fBHidden\fP is useful for people who like to keep a small window with
xweather running in it displayed all the time.
.PP
.B Help
.IP
Display this man page in a text window.
.PP
.B Quit
.IP
leave xweather.
.RE
.SH OPTIONS
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to use for 
displaying graphical weather maps.
.TP 8
.B \-geometry \fIgeom\fP
This option specifies the size and/or location of the windows created
by \fIxweather\fP. The window geometry is constrained to a certain aspect
ratio, so the specified geometry will be coalesced into one that
satisfies this aspect ratio while attempting to make minimal adjustment
to the specified dimensions.
.TP 8
.B \-bw \fIpixels\fP
This option specifies the width in pixels of the border surrounding drawn
windows.
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border surrounding drawn
windows.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the name of the color to be used as the background of 
drawn windows.
The default is to use the BlackPixel of the screen.
.TP 8
.B \-monochrome
This option forces monochrome (black and white) mode even if the X display
is capable of color. For \fIxweather\fP's purposes, a grayscale display is
considered monochrome unless forced into color mode by the \fB\-color\fP
option, in which case the color resources must be set to more reasonable
values for a grayscale monitor to make the drawn maps legible.
.TP 8
.B \-color
This option forces color mode even if the X display would otherwise be
considered black and white. This would typically only be useful on a
grayscale display (see above).
.TP 8
.B \-rv
This option is only examined if \fIxweather\fP is running in black and white
mode, and causes reverse video (white on black) maps to be drawn. The
default is to draw black on white maps.
.TP 8
.B \-xrm \fIresource string\fP
This option specifies a resource string to be used.
This is especially useful for setting resources that
do not have separate command line options.
.SH "X DEFAULTS"
The \fIxweather\fP program uses the following X resources:
.TP 8
.B autoRescan (\fPclass\fB Boolean)
Controls whether or not \fIxweather\fP tries to re-load data from the server
automatically.
.TP 8
.B display (\fPclass\fB Display)
Specifies the name of the X display to which to connect.
.B Display.ars (\fPclass\fB Boolean)
.TP 8
.br
.B Display.clouds
.ti -0.75i
.br
.B Display.dew
.ti -0.75i
.br
.B Display.fronts
.ti -0.75i
.br
.B Display.isoBars
.ti -0.75i
.br
.B Display.isoDew
.ti -0.75i
.br
.B Display.isoTherms
.ti -0.75i
.br
.B Display.names
.ti -0.75i
.br
.B Display.pressure
.ti -0.75i
.br
.B Display.radar
.ti -0.75i
.br
.B Display.regions
.ti -0.75i
.br
.B Display.temp
.ti -0.75i
.br
.B Display.visibility
.ti -0.75i
.br
.B Display.watches
.ti -0.75i
.br
.B Display.weatherSymbols
.ti -0.75i
.B Display.wind
.br
control whether the particular feature is displayed on the map.
Any of these options can be changed by using the Change menu.
.TP 8
.B geometry (\fPclass\fB Geometry)
Specifies the size and/or location of the windows that \fIxweather\fP draws.
.TP 8
.B gmtTime (\fPclass\fB Boolean)
If this resource is defined to be true, then all times will be displayed in
Greenwich mean time instead of local time.
.TP 8
.B monochrome (\fPclass\fB Monochrome)
Forces monochrome mode on a color display (see the discussion of the
\fB\-monochrome\fP and \fB\-color\fP command line options).
.TP 8
.B forceColor (\fPclass\fB ForceColor)
Forces color mode on a grayscale display (see the discussion of the
\fB\-monochrome\fP and \fB\-color\fP command line options).
.TP 8
.B rawConditions (\fPclass\fB Boolean)
When this resource is defined, the raw weather conditions are displayed at
the top of the map and in the current conditions popup display.
This feature is only useful if you understand NWS weather reporting 
abbreviations.
.TP 8
.B serverHost (\fPclass\fB String)
Defines the name of the host that is running the weather server.
.TP 8
.B serverPort (\fPclass\fB Integer)
Defines the TCP port number to use to connect to the weather server.
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
If \fIxweather\fP is running in black and white
mode, causes reverse video (white on black) maps to be drawn. The
default is to draw black on white maps.
.TP 8
.B borderWidth (\fPclass\fB BorderWidth)
Specifies the border width in pixels.
.TP 8
.B borderColor (\fPclass\fB Color)
Specifies the color of the border.
.TP 8
.B background (\fPclass\fB Color)
Specifies the color to be used for the background of the 
windows that \fIxweather\fP draws.
.TP 8
.B idFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing three-letter station
identifiers on the map.
.TP 8
.B dataFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing weather data (like
temperature, dewpoint, and visibility) on the map.
.TP 8
.B titleFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing the map title in
the legend in the upper left of the map.
.TP 8
.B legendFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing other
legend information on the map.
.TP 8
.B largeARSFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing large text
(currently only the NE and NA symbols)
on the Automated Radar Summary map.
.TP 8
.B smallARSFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing small text
(maximum tops and special conditions)
on the Automated Radar Summary map.
.TP 8
.B watchBoxFont (\fPclass\fB Font)
Specifies the name of the font to use for drawing the names of
severe weather watch boxes on the map.
.TP 8
.B mapColor (\fPclass\fB Color)
Specifies the color in which the state outline map is to be drawn.
.TP 8
.B dataColor (\fPclass\fB Color)
Specifies the color in which most map symbols and text are to
be drawn.
.TP 8
.B dimDataColor (\fPclass\fB Color)
Specifies the color in which less important map symbols (currently isobars
and the NE and NA symbols on the Automated Radar Summary) are to
be drawn.
.TP 8
.B regionColor (\fPclass\fB Color)
Specifies the color in which defined regions (such as the severe storm risk
areas) are to be filled.
.TP 8
.B watchBoxColor (\fPclass\fB Color)
Specifies the color in which severe storm watch boxes are to be drawn.
.TP 8
.B vip1Color \fPthrough\fB vip6Color (\fPclass\fB Color)
Specifies the six colors in which the six different intensities of radar
echoes are to be drawn on the radar summary maps. 1 is the least intense, 6
the most intense.
.TP 8
.B warmFrontColor (\fPclass\fB Color)
Specifies the color in which warm fronts are to be drawn.
.TP 8
.B coldFrontColor (\fPclass\fB Color)
Specifies the color in which cold fronts are to be drawn.
High pressure centers are also drawn in this color.
.TP 8
.B stationaryFrontColor (\fPclass\fB Color)
Specifies the color in which stationary fronts are to be drawn.
.TP 8
.B occludedFrontColor (\fPclass\fB Color)
Specifies the color in which occluded fronts are to be drawn.
Low pressure centers are also drawn in this color.
.SH "SEE ALSO"
X(1), wxmap
.SH BUGS
.PP
The server currently is not providing any Canadian data.
.PP
There should be a command to display an X window with a symbol
legend on it. 
.PP
There should be an option to hid the button and help windows.
.SH CAVEAT
This is experimental software.
.SH COPYRIGHT
Copyright 1991, Jeff Hollingsworth.
.br
Copyright 1990, Charley Kline and the Trustees of the University of
Illinois.
.br
Copyright 1987, 1988 Massachusetts Institute of Technology
.SH AUTHORS
Jeff Hollingsworth (hollings@cs.wisc.edu)
.PP
Xweather (and this man page) is derived on the program wxmap written by 
Charley Kline, University of Illinois Computing Services Office.
(c-kline@uiuc.edu). 
.PP
Module sadecode.c and parts of the weather server by Paul Gibbs, University
of Illinois Computing Services Office.
.PP
The help window uses the ScrollByL widget developed for the Xman program by 
Chris D. Peterson.
