#ifndef midiout_h
#define midiout_h
#include <stdio.h>
#include "typed_queue.h"
#include "sorted_intlist.h"

struct beatpairlist;
struct beatpair {
  int beat;
  int emph;
  const char *inst;
  struct beatpairlist *parent;
};

DECLARE_TYPED_QUEUE(struct beatpair, bp);

typedef struct beatpairlist {
  bp_queue q;
  int measure_beats;
} *beatpairlist;

/* really for the parser, not for the midi subsystem */
struct instrument {
  char *inst;
  int emph;
};

struct lyricpattern { 
  const char *lyr;
  int patternreq;
};

void midi_set_bpm(int bpm);
void midi_set_volume(int volume);
void midi_writelyric(const char *annot);
void midi_writetitle(const char *title);
void midi_writepattern(const beatpairlist bpl);
void midi_set_filep(FILE *output);
void midi_zero_volume_note(void);
unsigned char midi_lookup_instrument(const char *inst);

void bpl_insert(beatpairlist bpl, 
                sorted_intlist beats, 
                const char *inst, int emph);
boolean bpl_merge(beatpairlist dst, beatpairlist src);
void bpl_set_measure_beats(beatpairlist bpl, int mb);
beatpairlist bpl_new(void);
void bpl_print(FILE *fpout, beatpairlist bpl);
#endif
