%{
#include <config.h>
#include <stdlib.h>
#include "midiout.h"
#include "sorted_intlist.h"
#ifdef WITH_DMALLOC
#include<dmalloc.h>
#endif
#define MAX_PATTERNS 1024
  struct beatpairlist *patterns[MAX_PATTERNS];
  int patternsused[MAX_PATTERNS];
  int yyerror(const char *string);
  int yylex(void);
  extern int verbose;
%}
%union {
  char*                 sval;
  int                   ival;
  struct { short beat; short twelfth; } bval;
  struct beatpairlist * bpval;
  struct lyricpattern * lpval;
  struct sorted_intlist_struct * sival;
};

%token <lpval> TOK_PATTERN
%token TOK_NULLPATTERN
%token TOK_DIRECTIVE
%token TOK_PATTERNDECL
%token TOK_SET
%token TOK_NEWL
%token <sval> TOK_TITLE
%token TOK_LBRACE
%token TOK_RBRACE
%token <ival> TOK_NUMBER
%token <bval> TOK_BEAT
%token <sval> TOK_ID
%token TOK_DOTDOT

%type <bpval> beatpairlist
%type <ival> patternuse
%type <ival> emph
%type <sival> numberlist

%% 

file : headerlinelist prepattern patternuselist {
  /* generate a warning if a pattern was declared and not used
     but no real processing */
  int i;
  for(i=0;i<MAX_PATTERNS;i++) {
    if(patterns[i]!=NULL && patternsused[i] ==0) {
      printf("warning: pattern %d never used\n", i);
    }
  }
};

prepattern : prepattern TOK_NEWL | 
             prepattern TOK_NULLPATTERN | 
;

headerlinelist: headerlinelist headerline | 
              	headerlinelist TOK_NEWL | ;
headerline: set | patterndecl | title; 

title: TOK_DIRECTIVE TOK_TITLE TOK_NEWL { 
  midi_writetitle($2); 
  free($2); 
};

set: TOK_DIRECTIVE TOK_SET TOK_ID TOK_NUMBER TOK_NEWL { 
  /* parameters are (4/4) beats-per-minute and volume */
  if(strcmp($3, "bpm") == 0) {
    midi_set_bpm($4);
  } else if(strcmp($3, "volume") == 0) {
    midi_set_volume($4);
  } else {
    printf("would set %s to %d if I knew what it was\n", $3, $4);
  }
  free($3);
};

patterndecl: TOK_DIRECTIVE TOK_PATTERNDECL TOK_NUMBER TOK_NUMBER TOK_LBRACE beatpairlist TOK_RBRACE TOK_NEWL { 
  if( $3 >= MAX_PATTERNS ) {
    printf("WARNING: pattern #%d is out of range - only %d patterns supported.\n", $3, MAX_PATTERNS); 
  } else if(patterns[$3] != NULL) {
    printf("WARNING: pattern %d already defined\n", $3);
  } else {
    if(verbose) { 
      printf("pattern %d declared: \n", $3); 
      bpl_print(stdout, $6);
    }
    patterns[$3] = $6;
    bpl_set_measure_beats($6, $4 * 12);
  }
};

beatpairlist: numberlist TOK_ID emph beatpairlist {
  bpl_insert($4, $1, $2, $3); 
  $$ = $4; }
| TOK_PATTERN beatpairlist {
  if($1->patternreq < MAX_PATTERNS && patterns[$1->patternreq] != NULL) {
    bpl_merge($2, patterns[$1->patternreq]);
    patternsused[$1->patternreq]++;
  } else {
    char errmsg[255];
    sprintf(errmsg, "failed to lookup pattern %d", $1->patternreq);
    yyerror(errmsg);
    exit(EXIT_FAILURE); /* a fatal error */
  }
  free($1);
  $$ = $2;
}
| { $$ = bpl_new(); };

numberlist: numberlist TOK_NUMBER { 
  si_insert($1, ($2-1) * 12); 
  $$=$1; } 
| numberlist TOK_BEAT { 
  si_insert($1, ($2.beat - 1) * 12 + $2.twelfth ); 
  $$=$1; } 
| numberlist TOK_NUMBER TOK_DOTDOT TOK_NUMBER { 
  int i; 
  $$= $1; /* not really a tested codepath */
  for(i=$2;i<=$4;i++) { 
    si_insert($$, (i-1) * 12); 
  } 
} 
| TOK_NUMBER TOK_DOTDOT TOK_NUMBER { 
  int i; 
  $$ = si_new(); 
  for(i=$1;i<=$3;i++) { 
    si_insert($$, (i-1) * 12); 
  } 
} 
| TOK_NUMBER { $$ = si_new(); si_insert($$, ($1-1) * 12); }
| TOK_BEAT { $$ = si_new(); si_insert($$, ($1.beat-1) * 12 + $1.twelfth); };

emph: '-' emph { $$ = $2 - 1; } |
      '!' emph { $$ = $2 + 1; } |
      { $$ = 0; };

patternuselist: patternuselist patternuse | ;

patternuse: TOK_PATTERN { 
  $$ = $1->patternreq; 
  midi_writelyric($1->lyr);
  if($1->patternreq < MAX_PATTERNS && patterns[$1->patternreq] != NULL) {
    midi_writepattern(patterns[$1->patternreq]);
    patternsused[$1->patternreq]++;
  } else {
    char errmsg[255];
    sprintf(errmsg, "failed to lookup pattern %d", $1->patternreq);
    yyerror(errmsg);
  }
  /* done. */
  free((char *)$1->lyr);
  free($1);
};
