#include <stdlib.h>

struct sound {
  const char *name;
  unsigned char note;
};

/*@+charint@*/
struct sound sounds[] = {
  { "Bass 1",          35 }, /* acoustic bass drum */
  { "Bass 2",          36 }, /* bass drum 1 */
  { "Rim",             37 }, /* side stick */
  { "Snare 1",         38 }, /* acoustic snare */
  { "Hand Clap",       39 },
  { "Snare 2",         40 }, /* electric snare */
  { "LowTom",          41 }, /* low floor tom */
  { "High Hat Closed", 42 }, /* closed hi hat */
  { "High Floor Tom",  43 }, 
  { "MidTom",          45 }, /* low tom */
  { "High Hat Open",   46 }, /* open hi hat */
  { "Low-Mid Tom",     47 }, 
  { "Hi Mid Tom",      48 }, 
  { "Crash",           49 }, /* crash cymbal 1 */
  { "High Tom",        50 }, 
  { "Ride",            51 }, /* ride cymbal 1 */
  { "Tambourine",      54 }, 
  { "Cowbell",         56 }, 
  { "Crash 2",         57 }, /* crash cymbal 2 */
  { "Ride 2",          59 }, /* ride cymbal 2 */
  { "HiBongo",         60 }, 
  { "LowBongo",        61 }, 
  { "Maracas",         70 }, 
  { "Claves",          75 }, 
  { "Mute Triangle",   80 }, 
  { "Open Triangle",   81 }, 
  { NULL, 0 }};
   
/*@-charint@*/

/* http://www.midi.org/about-midi/gm/gm1sound.shtml#percussion 
35 x	Acoustic Bass Drum	59	Ride Cymbal 2 
36 x	Bass Drum 1		60	Hi Bongo
37 x	Side Stick		61	Low Bongo
38 x	Acoustic Snare		62	Mute Hi Conga
39 x	Hand Clap		63	Open Hi Conga
40 x	Electric Snare		64 	Low Conga
41 x	Low Floor Tom		65 	High Timbale
42 x	Closed Hi Hat		66	Low Timbale
43 o	High Floor Tom		67	High Agogo
44	Pedal Hi-Hat		68	Low Agogo
45 x	Low Tom 		69	Cabasa
46 x	Open Hi-Hat		70	Maracas
47 o	Low-Mid Tom 		71	Short Whistle
48 x	Hi Mid Tom 		72	Long Whistle
49 x	Crash Cymbal 1		73	Short Guiro
50 o	High Tom		74	Long Guiro
51 x	Ride Cymbal 1		75	Claves
52	Chinese Cymbal		76	Hi Wood Block
53	Ride Bell		77	Low Wood Block
54 x	Tambourine		78	Mute Cuica
55	Splash Cymbal		79	Open Cuica
56 x	Cowbell			80	Mute Triangle
57	Crash Cymbal 2		81	Open Triangle
58	Vibraslap
*/
