/*-*- mode:C; -*- */
%option yylineno
%{
#define _GNU_SOURCE
  // #include <features.h>
#include <ctype.h>
#include "poker.h"
#include <string.h>
#include "midiout.h"
  extern FILE *fchordata;
  static int lastpatternreq; 
  static int linechars;
  static int last_act;
  extern const char *input_filename;
  
#define YY_USER_ACTION ( linechars += yyleng, last_act = yy_act);
  
  static const char *trim_and_dup(const char *trimme) {
    int len;
    int left;
    for(left=0; trimme[left] != '\0' && isspace(trimme[left]); left++);
    for(len = strlen(&trimme[left]);
        len >= 0 && isspace(trimme[left+len]);
        len--);
    if(len>0) {
#ifdef HAVE_STRNDUP
      /* strndup always add a NUL terminator */
      return(strndup(&trimme[left], len+1));
#else
      char *r = strdup(&trimme[left]);
      r[len]='\0';
      return r;
#endif
    } else {
      return(NULL);
    }
  }
  
%}

%x directive
%x pattern
%%

^@ {
 /* 1 */
 BEGIN(directive);
 return TOK_DIRECTIVE;
}

^#.*\n {
  /* 2 */
	/* consider hash lines to be drm comments, swallow them now. */
}

<pattern>\x7c[0-9]+ {
  yylval.lpval = malloc(sizeof(struct lyricpattern));
  yylval.lpval->patternreq = lastpatternreq = atoi(yytext+1);
  return TOK_PATTERN;
}

\x7c[0-9]+[^\x7c]* {
 /* 3 */
/* x7c is the pipe character (7c hex) */
  int offs = 0;
  yylval.lpval = malloc(sizeof(struct lyricpattern));
  yylval.lpval->patternreq = lastpatternreq = atoi(yytext+1);

  /* skip the digits in the drum pattern request */
  for(offs = 1; 
      (yytext[offs] != '\0') && isdigit(yytext[offs]); 
      offs++);

  if(fchordata) fprintf(fchordata, "%s", &yytext[offs]);

  /*strip leading whitespace for lyr annotation*/
  yylval.lpval->lyr = trim_and_dup(&yytext[offs]);
  return TOK_PATTERN;
}

[^@\x7c\n]+ {
 /* 4 */
/* bug - will reject @ as not the first character in the 
 line, introduced to make sure directive matching rule
 matches first. */
  return TOK_NULLPATTERN;
}

\x7c[^0-9\x7c][^\x7c]* {
 /* 5 */
/* x7c is the pipe character (7c hex) */
  int offs = 1;
  yylval.lpval = malloc(sizeof(struct lyricpattern));
  yylval.lpval->patternreq = lastpatternreq;
  if(fchordata) fprintf(fchordata, "%s", &yytext[offs]);
  /*strip leading whitespace for lyr annotation*/
  yylval.lpval->lyr = trim_and_dup(&yytext[offs]);
  return TOK_PATTERN;
}

\x7c\x7c {
 /* 6 */
  yylval.lpval = malloc(sizeof(struct lyricpattern));
  yylval.lpval->patternreq = lastpatternreq;
  yylval.lpval->lyr = NULL;
  unput(0x7c);
  return TOK_PATTERN;
}

<pattern>\x2e\x2e {
 /* 7 */
  return TOK_DOTDOT;
}

<directive,pattern>[0-9]+ {
 /* 8 */
  yylval.ival = atoi(yytext);
  return TOK_NUMBER;
}

<pattern>[0-9]+[e+atdl] {
 /* 9 */
  char c;
  if(sscanf(yytext, "%hd%c", &yylval.bval.beat, &c) < 2) {
    printf("huh?");
  }
  switch(c) {
  case 'e': yylval.bval.twelfth = 3; break;
  case 't': yylval.bval.twelfth = 4; break;
  case '+': yylval.bval.twelfth = 6; break;
  case 'd': 
  case 'l': yylval.bval.twelfth = 8; break;
  case 'a': yylval.bval.twelfth = 9; break;
  default: printf("no.\n"); exit;
  }
  return TOK_BEAT;
}

<pattern>"-" {
 /* 10 */
  return('-');
}
<pattern>"!" {
 /* 11 */
  return('!');
}

<directive>"{" { 
 /* 12 */
  BEGIN(pattern);
  return(TOK_LBRACE);
}

<pattern>"}"[^\n]* { 
 /* 13 */
  /* vile nastiness to have right braces gobble stuff here, but I 
     couldn't think of a better way in a minute. */
  BEGIN(directive);
  return(TOK_RBRACE);
}


<directive>title[^\n]+ { 
 /* 14 */
  yylval.sval = strdup(yytext+5); 
  return TOK_TITLE; 
}

<directive>set   { 
 /* 15 */
  return TOK_SET; 
}

<directive>pattern { 
 /* 16 */
  return TOK_PATTERNDECL; 
}

<directive,pattern>[[:alpha:]]+[[:digit:]]* {
 /* 17 */
 /* unquoted instruments or 'bpm' */
  yylval.sval = strdup(yytext);
  return TOK_ID;
}

<directive,pattern>\"[^\"}]*\" {
  yylval.sval = strdup(yytext+1);
  if(strlen(yylval.sval) != yyleng-1) {
    printf("huh?");
  }
  yylval.sval[strlen(yylval.sval)-1] = '\0';
  return TOK_ID;
}

<directive,pattern>\'[^\'}]*\' {
  yylval.sval = strdup(yytext+1);
  if(strlen(yylval.sval) != yyleng-1) {
  printf("huh?");
  }
  yylval.sval[yyleng-2] = '\0';
  return TOK_ID;
}

<*>.  { 
//  if(fchordata) fprintf(fchordata, "%s", yytext); 
}

<pattern>"{" {
  yyerror("apparently unterminated pattern\n");
}

<directive,INITIAL>\n { 
  BEGIN(INITIAL);
  linechars = 0;
  return TOK_NEWL;
}

<pattern>\n { 
  linechars = 0;
}
<pattern>#.*\n {
/* comment in a pattern */
}
<directive,pattern>. {
 if(fchordata) fprintf(fchordata, "x%s", yytext); 
}



%%

int yyerror(const char *string __attribute__((unused))) {
  fprintf(stdout,"%s:%d:%d - lexer error in after match of rule %d.\n  %s\n", input_filename, yylineno, linechars, last_act, string);
  return (1);
}

