function allmbasecomp(exp,r1,r2)
% allmbasecomp(EXP)
%     Plots and summarizes the results of experiment EXP for all
%     for values of M (5,10,15,50).
% ----------
% Tamara Gibson
% Applied Math Program, Univ. of Maryland, College Park, MD 20742
% gibson@math.umd.edu
% http://www.cs.umd.edu/~gibson
% ----------
% Companion to:
% Tamara Gibson, Dianne P. O'Leary and Larry Nazareth
% "BFGS with Update Skipping and Varying Memory"
% Technical Report CS-TR-3663 UMIACS-TR-96-49
% University of Maryland College Park, 1996
% ----------
% 1996
% ----------

% Additional Options
% allmbasecomp(EXP,R1,R2)
%     Plots and summarizes the results of experiment EXP for all
%     for values of M (5,10,15,50) for problems in the range R1 to R2.

o = ones(22,1);
mvec = [5,10,15,50];
count = 4;
dim = [2,2];
for i = 1:count
  M = mvec(i);
  if ((exist('r1')~=1)|(exist('r2')~=1))
    [X,Y,expstr,expfail,exp0fail,bothfail] = basecompare(M,exp,0);
  else
    [X,Y,expstr,expfail,exp0fail,bothfail] = basecompare(M,exp,0,r1,r2);
  end
  s = size(X,1);
  for j = 1:s
    for k = 2:4
      if X(j,k) > 2.0
	X(j,k) = 2.0;
      end
    end
  end
  subplot(dim(1),dim(2),i)  
  plot(X(:,1),X(:,2),'y+')
  hold on
  plot(X(:,1),X(:,3),'ro')
  plot(X(:,1),X(:,4),'gx')
  V = axis;
  if ((exist('r1')~=1)|(exist('r2')~=1))
    V(2) = 23;
  else
    V(1) = r1 - 1;
    V(2) = r2 + 1;
  end
  V(3) = min([0,V(3)]);
  V(4) = max([2,V(4)]);
  axis(V)
  title(['M=',num2str(M)]);
  ylabel('Ratio');
  plot(o,'c:');
  hold off
  
  if (i == 1)
    fprintf(1,'\n ** Experiment %d (%s) Summary ** \n',exp,expstr);
    if ((exist('r1')==1)&(exist('r2')==1))
      fprintf(1,' ** Problem Range: %d - %d ** \n',r1,r2);
    end
  end
  
  fprintf(1,'\nM=%d\n',M);
  fprintf(1,'       Iters  Fevals  Time\n');
  fprintf(1,'       ------ ------ ------\n');
  fprintf(1,'Mean   %6.3f %6.3f %6.3f\n',Y(1,:));
  fprintf(1,'Median %6.3f %6.3f %6.3f\n',Y(2,:));
  fprintf(1,'Min    %6.3f %6.3f %6.3f\n',Y(3,:));
  fprintf(1,'Max    %6.3f %6.3f %6.3f\n',Y(4,:));
  fprintf(1,'\n');
  fprintf(1,'Both Failed: %2d   Base Failed: %2d   Exp Failed: %d\n',...
    bothfail, exp0fail, expfail);
end
strng = ['Experiment ',num2str(exp)];
text(-10,-.5,strng)

