function [X,Y,estr,efail,e0fail,bfail] = basecomp(M,exp,opt,r1,r2)
% basecomp(M,EXP)
%     Compares experiment EXP with limited-memory constant M to
%     normal LM-BFGS in terms of iterations, function evaluations,
%     and time.  
% ----------
% Tamara Gibson
% Applied Math Program, Univ. of Maryland, College Park, MD 20742
% gibson@math.umd.edu
% http://www.cs.umd.edu/~gibson
% ----------
% Companion to:
% Tamara Gibson, Dianne P. O'Leary and Larry Nazareth
% "BFGS with Update Skipping and Varying Memory"
% Technical Report CS-TR-3663 UMIACS-TR-96-49
% University of Maryland College Park, 1996
% ----------
% 1996
% ----------

% Additional Options:
% basecompare(M,EXP,OPT,R1,R2)
% Optional parameters: 
% Set OPT to 0 to supress output.
% Set R1, R2 to specify a problem range to focus on.

if (exist('opt') ~= 1)
  opt = 1;
end
if (exist('r1') ~= 1)
  r1 = 1;
end

load results.mat

[S,estr,totalprob,count] = expsum(M,exp,0);

if (exist('r2') ~= 1)
  r2 = totalprob;
end

S0 = expsum(M,0,0);

efail = 0;
e0fail = 0;
bfail = 0;
j = 0;
for i = r1:r2
  if (S(i,1) ~= 0)
    if (S0(i,1) ~= 0)
      bfail = bfail + 1;
    else
      efail = efail + 1;
    end
  elseif (S0(i,1) ~= 0)
    e0fail = e0fail + 1;
  else
    j = j + 1;
    X(j,1) = i;
    X(j,2) = S(i,2)/S0(i,2);
    X(j,3) = S(i,3)/S0(i,3);
    X(j,4) = S(i,4)/S0(i,4);
  end
end
for i = 2:4
  Y(1,i-1) = mean(X(:,i));
  Y(2,i-1) = median(X(:,i));
  Y(3,i-1) = min(X(:,i));
  Y(4,i-1) = max(X(:,i));
end

if (opt ~= 0)
  fprintf(1,'\nExperiment %2d: %s\n',exp,estr);
  fprintf(1,'M = %d\n\n',M);
  fprintf(1,'         Both Failed: %d\n',bfail);
  fprintf(1,'Experiment  0 Failed: %d\n',e0fail);
  fprintf(1,'Experiment %2d Failed: %d\n\n',exp, efail);
  fprintf(1,'Ratio of Exp %d Results to Exp 0 Results...\n\n',exp);
  fprintf(1,'    Problem        Iters   F-Evals   Time\n');
  fprintf(1,'---------------   -------  -------  -------\n');
  for i = 1:j
    fprintf(1,' %2d %-10s    %6.3f   %6.3f   %6.3f\n',X(i,1),...
      ['(',eval(['prob',num2str(X(i,1))]),')'],X(i,2),X(i,3),X(i,4));
  end
  fprintf(1,'\n Mean:            %6.3f   %6.3f   %6.3f\n',...
    mean(X(:,2)),mean(X(:,3)),mean(X(:,4)));
  fprintf(1,' Median:          %6.3f   %6.3f   %6.3f\n',...
    median(X(:,2)),median(X(:,3)),median(X(:,4)));
  fprintf(1,' Min:             %6.3f   %6.3f   %6.3f\n',...
    min(X(:,2)),min(X(:,3)),min(X(:,4)));
  fprintf(1,' Max:             %6.3f   %6.3f   %6.3f\n\n',...
    max(X(:,2)),max(X(:,3)),max(X(:,4)));

  % plot picture
  plot(X(:,1),X(:,2),'y+')
  hold on
  plot(X(:,1),X(:,3),'ro')
  plot(X(:,1),X(:,4),'gx')
  V = axis;
  V(2) = 23;
  V(3) = min([0,V(3)]);
  V(4) = max([2,V(4)]);
  axis(V)
  title(['Exp ',num2str(exp),': ',estr,' M=',num2str(M),...
      '  (+,o,x: iters, fevals, time)']);
  ylabel('Ratio');
  hold off
end