function [S,expstr,totalprob,count] = expsum(M,exp,opt)
% [S,expstr,totalprob,count] = expsum(M,exp,opt)
%
% expsum(M,EXP)
%     Summarize results from experiment EXP with the 
%     memory parameter set to M.  
% ----------
% Tamara Gibson
% Applied Math Program, Univ. of Maryland, College Park, MD 20742
% gibson@math.umd.edu
% http://www.cs.umd.edu/~gibson
% ----------
% Companion to:
% Tamara Gibson, Dianne P. O'Leary and Larry Nazareth
% "BFGS with Update Skipping and Varying Memory"
% Technical Report CS-TR-3663 UMIACS-TR-96-49
% University of Maryland College Park, 1996
% ----------
% 1996
% ----------

% Additional Info
% expsum(M,EXP,OPT)
%     OPT is an optional parameter which indicates
%     that a summary should be printed out when it is anything
%     nonzero.  The default is that nothing will be printed.
%     EXPSUM returns four values.  S is a matrix whose rows
%     correspond to the problems and whose columns correspond
%     to exit code, iterations, fevals, and time respectively.
%     EXPSTR is a string containing the name of the experiment.
%     TOTALPROB is the total number of problems.  COUNT is the
%     number of problems for which the experiment failed.

if (exist('opt') ~= 1)
  opt = 1;
end

load results.mat

totalexp = size(A,1);

for i = 1:totalexp
  if ((A(i,3) == 5) | (A(i,3) == 10) | (A(i,3) == 15) | (A(i,3) == 50))
    % Do Nothing
  else
    fprintf(1,'Error on line %d M=%d\n',i,A(i,3));
  end
  if ((A(i,1) == exp) & (A(i,3) == M))
    j = A(i,2); % Problem Number
    S(j,1) = A(i,4); % Error Code
    S(j,2) = A(i,5); % Iterations
    S(j,3) = A(i,6); % F-Evals
    S(j,4) = A(i,7); % Time
  end
end

expstr = eval(['exp',num2str(exp)]);

totalprob = size(S,1);
count = 0;
for i = 1:totalprob
  if S(i,1) ~= 0
    count = count+1;
  end
end
if (opt ~= 0)
  fprintf(1,'Experiment Number: %d\n',exp);
  fprintf(1,'Experiment Summary: %s\n',expstr);
  fprintf(1,'Total Problems: %d\n',totalprob);
  fprintf(1,'Failures to Converge: %d\n',count);
  fprintf(1,'\nProblem   Fail  Iters  Fevals   Time\n');
  fprintf(1,'--------  ----  -----  ------   ----\n');
  for i=1:totalprob
    expression = ['prob',num2str(i)];
    fprintf(1,'%8s  %3d  %5d   %5d %7.2f \n',...
      eval(expression),S(i,1),S(i,2),S(i,3),S(i,4));
  end
end
  









