function [S,probstr,totalexp,count] = probsum(M,prob,opt)
% probsum(M,PROB)
%     Summarizes the results of each experiment with 
%     limited-memory constant M for problem PROB.
% ----------
% Tamara Gibson
% Applied Math Program, Univ. of Maryland, College Park, MD 20742
% gibson@math.umd.edu
% http://www.cs.umd.edu/~gibson
% ----------
% Companion to:
% Tamara Gibson, Dianne P. O'Leary and Larry Nazareth
% "BFGS with Update Skipping and Varying Memory"
% Technical Report CS-TR-3663 UMIACS-TR-96-49
% University of Maryland College Park, 1996
% ----------
% 1996
% ----------

if (exist('opt') ~= 1)
  opt = 1;
end

load results.mat

totalexp = size(A,1);

for i = 1:totalexp
  if ((A(i,2) == prob) & (A(i,3) == M))
    j = A(i,1)+1; % Experiment Number + 1
    S(j,1) = A(i,4); % Error Code
    S(j,2) = A(i,5); % Iterations
    S(j,3) = A(i,6); % F-Evals
    S(j,4) = A(i,7); % Time
  end
end

probstr = eval(['prob',num2str(prob)]);
totalexp = size(S,1);
count = 0;
for i = 1:totalexp
  if S(i,1) ~= 0
    count = count + 1;
  end
end

if (opt ~= 0) 
  fprintf(1,'Problem: %d (%s)\n',prob,probstr);
  fprintf(1,'Failures to Converge: %d\n',count);
  fprintf(1,'\n');
  fprintf(1,'Exp Iters Fevals Time (sec)\n');
  fprintf(1,'--- ----- ------ ----------\n');
  
  for i = 1:22
    if (S(i,1) == 0)
      fprintf(1,'%2d  %4d   %4d  %8.3f\n',i-1,S(i,2),S(i,3),S(i,4));
    else
      fprintf(1,'%2d\n',i-1);
    end
  end
end
  





    