function Z = rankit(M,prob,foo)
% rankit(M,prob,foo)
%      Ranks the various experiments for a problem PROB with
%      the variable memory parameter set to M and with FOO
%      equal 1 (iters), 2 (fevals), or 3 (time) giving the
%      ranking criteria.
% ----------
% Tamara Gibson
% Applied Math Program, Univ. of Maryland, College Park, MD 20742
% gibson@math.umd.edu
% http://www.cs.umd.edu/~gibson
% ----------
% Companion to:
% Tamara Gibson, Dianne P. O'Leary and Larry Nazareth
% "BFGS with Update Skipping and Varying Memory"
% Technical Report CS-TR-3663 UMIACS-TR-96-49
% University of Maryland College Park, 1996
% ----------
% 1996
% ----------

load results.mat

foo = foo + 1;

[S,probstr,totalexp,count] = probsum(M,prob,0);
%fprintf(1,'\nPROBLEM: %d (%s)\n\n',prob,probstr);

% Get Non-Failures
j = 1;
k = 1;
for i = 1:totalexp
  if S(i,1) == 0
    X(j,1) = i;
    X(j,2) = S(i,foo);
    j = j+1;
  else
    U(k,1) = i;
    k = k + 1;
  end
end
count = j-1;
altcount = k-1;
% Sort X
[Y,I] =sort(X(:,2));
for i = 1:count
  Z(i,:) = X(I(i),:);
end

if (foo == 2)
  fprintf(1,' Iters   Expermiment\n');
  fprintf(1,' -----   -----------\n');
elseif (foo == 3)
  fprintf(1,'F-Evals  Expermiment\n');
  fprintf(1,'-------  -----------\n');
else
  fprintf(1,'    Time  Expermiment\n');
  fprintf(1,'    ----  -----------\n');
end
if (foo < 4)
  for i=1:count
    fprintf(1,'%6d   %2d (%s)\n',Z(i,2),Z(i,1)-1,eval(['exp',num2str(Z(i,1)-1)]));
  end
  for i=1:altcount
    fprintf(1,'  FAIL   %2d (%s)\n',U(i,1)-1,eval(['exp',num2str(U(i,1)-1)]));
  end
else
  for i=1:count
    fprintf(1,'%8.2f  %2d (%s)\n',Z(i,2),Z(i,1)-1,eval(['exp',num2str(Z(i,1)-1)]));
  end
  for i=1:altcount
    fprintf(1,'    FAIL  %2d (%s)\n',U(i,1)-1,eval(['exp',num2str(U(i,1)-1)]));
  end
end




end