% This file gives census data for Tribolium
% castaneum colonies studied by 
%
% Robert A. Desharnais and Laifu Liu,
% "Stable demographic limit cycles in laboratory
% populations of Tribolium castaneum,"
% Journal of Animal Ecology 56, No. 3, 1987, 885-906.
%
% They observed four colonies (a, b, c, and d) for
% 266 days, making observations every 14 days.
%
% The first column is the day on which obervations
% were made.
%
% The columns labeled "A" give the number of adults.
% The columns labeled "P" give the number of pupae.
% The columns labeled "L" give the number of larvae.
% 
% D  Aa  Ab  Ac  Ad  Pa  Pb  Pc  Pd  La  Lb  Lc  Ld
Data = [
  0  64  64  64  64  35  35  35  35  70  70  70  70
 14  78  88  77  86   4   4  12  12 263 198 176 249
 28  78  84  79  80 109  77  71 100  75  75  87  28
 42  77  80  76  88  28  18  44  18 125 111  96 181
 56  61  69  61  80  77  40  31  61 203 226 180 173
 70  85  77  46  75  71  67  72  47  57  31  13  76
 84 102  98  72  76  36  11   7  36 182 246 222 254
 98 104  88  69  77 136 127 132 119  27  48 125  29
112 120 100 105 110  35   8  59  27 265 302 146 286
126 122  90 106 106  76 154 125  62  32  35 101   8
140 132 120  99 108  28  20  49   5 309 213 124 411
154 120 107  96  99 252 156  82 232   8 109 156  28
168 113 115  98 120   5  48  87   6 360 178  69 308
182  97 119  95  93 236 141  38 193  24 171 164  52
196 136 121  94 132  20  73  99  12 357  59  80 213
210 122 127 108 115 176  75  47 130  13 299 187 114
224 117 117  98 134   7 114 107  52 373   9  69  92
238 105 121 106 117 189  54  38  81  14 419 293 217
252 120 113  88 134  12 157 121  73 404   3  42  75  
266  99 125 106 139 226   9  22  63   2 351 215 164
]; 


% Here are the parameters obtained by Robert A. Desharnais and Laifu Liu
% using least squares, minimizing the difference in the
% log of the observed population and the log of the predicted population.
%
% The columns of the matrix param_dl correspond to
% each of the four colonies, and the combined colony.
%
% The rows of the matrix param_dl are:
%  c_el, c_ea, c_pa, b, mu_L, and mu_A.
%
%  a        b      c      d    
param_dl = [
  .0098   .0105  .0080  .0080 
  .0175   .0087  .0044  .0068 
  .0198   .0174  .0180  .0162 
23.3688 11.2483 5.3422 7.2024 
  .4726   .5014  .5082  .5646 
  .0934   .0930  .1468  .1099 ];

