function [diffs,L,P,A] = evalls2(param)

% [diffs,L,P,A] = evalls2(param)
% Beetles, Cannibalism, and Chaos
% This function is used for Problem 3, to 
% compute the difference between the measured
% data and the model predictions.
% There are 6 parameters for this model.
% The vector diffs records the 57 differences, and
% the vectors L, P, and A record the model predictions
% for 20 cycles.
%
% evalls2.m Dianne P. O'Leary 12/2006


global mydatafit myDays

% The parameters come in through the argument param.

   c_el = param(1);
   c_ea = param(2);
   c_pa = param(3);
   b    = param(4);
   mu_l = param(5);
   mu_a = param(6);


A0 = mydatafit(1,1);
P0 = mydatafit(1,2);
L0 = mydatafit(1,3);

% The function lpa is used to compute the model 
% predictions for 20 cycles.

[L,P,A] = lpa(b,c_el,c_ea,c_pa,mu_l,mu_a,L0,P0,A0,20);

A = A';
P = P';
L = L';

% The vector diffs records the 57 differences between
% the log of the predicted and the log of the measured
% data.
% eps is inserted to avoid taking log of 0 or negative numbers.

diffs = [log(max(eps,A(2:end))) - log(mydatafit(2:end,1)); 
         log(max(eps,P(2:end))) - log(mydatafit(2:end,2));
         log(max(eps,L(2:end))) - log(mydatafit(2:end,3))];


