function [z,zp] = a(x)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [z,zp] = a(x)
% This function  computes the coefficient a(x)
% for the differential equation
%   -(a(x) u'(x))' + c(x) u(x) = f(x)  for x in (0,1)
% with u(0)=u(1)=0.
%
% The function a should satisfy a(x) \ge a_0 > 0 on (0,1),
% and four cases are given, depending on the value of the
% global variable acase.
%
% Input:
%  x is a row or column vector of points
%
% Outputs:
%  z =  a(x)
%  zp = a'(x)
%
% a.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global acase

if (acase == 1)
   z = ones(size(x));
   zp = zeros(size(x));
elseif (acase == 2)
   z = 1 + x.^2;
   zp = 2*x;
elseif (acase == 3)
   z  = (x <= 1/3).*(1+x.^2) + (x > 1/3).*((x-1/3)+10/9);
   zp = (x <= 1/3).*(2*x)    + (x > 1/3);
else
   z  = (x <= 1/3).*(1+x.^2) + (x > 1/3).*(x+ 2*x.^2);
   zp = (x <= 1/3).*(2*x)    + (x > 1/3).*(4*x);
end
