function z = axlin(xpts,h,xend)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = axlin(xpts,h,xend)
% This function computes the values of a phi_i' phi_i' + c phi_i phi_i
% at the points specified by xpts,
% where phi_i is the i-th linear basis element.  It is
% used by quad in computing matrix entries for the finite element
% formulations.
%
% Input:
%  xpts is a row or column vector of points
%  abs(h) is the distance between mesh points 
%  xend is an endpoint of the interval over which the basis function
%    is nonzero.
%
% The definition of phi is
%             phi(x) = (x - xend)/h,
% so if h>0, then xend is the right endpoint of the interval over
% which the basis function is nonzero, and we are looking at the
% interval over which phi is increasing.
% If h < 0, then xend is the left endpoint, and we are looking at the
% interval over which phi is decreasing.
%
% Functions required: a, c
% Outputs:
%  z =  a(xpts) phi_i'(xpts) phi_i'(xpts) + c(xpts) phi_i(xpts) phi_i(xpts)
%
% axlin.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

phi =  (xpts-xend)/h;
phiprime = 1/h;

z = a(xpts)*(phiprime.^2) + c(xpts).*(phi.^2);
