function z = bxlin(xpts,h,x1,x2)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = bxlin(xpts,h,x1,x2)
% This function computes values of 
%      a phi'_i ,phi'_{i+1}) + c phi_i phi_{i+1}
% at the points xpts,
% where phi_i, are phi_{i+1} linear finite element basis functions.
% It used by quad in computing matrix entries for the finite element
% formulations.
%
% Input:
%  xpts is a row or column vector of points
%  h is the distance between mesh points 
%  x1 and x2 are the endpoints of the interval over which both
%     basis functions are nonzero.
%
% Functions required: a, c
% Outputs:
%  z =  a(xpts) phi_i'(xpts) phi_{i+1}'(xpts) 
%           + c(xpts) phi_i(xpts) phi_{i+1}(xpts)
%
% bxlin.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

phi1 =  (xpts-x1)/h;
phi1prime = 1/h;
phi2 = -(xpts-x2)/h;
phi2prime = -1/h;

z = a(xpts)*phi1prime*phi2prime + c(xpts).*phi1.*phi2;
