function z = c(x)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = c(x)
% This function  computes the coefficient c(x)
% for the differential equation
%   -(a(x) u'(x))' + c(x) u(x) = f(x)  for x in (0,1)
% with u(0)=u(1)=0.
%
% The function c should satisfy c(x) \ge  0 on (0,1),
% and three cases are given, depending on the value of the
% global variable ccase.
%
% Input:
%  x is a row or column vector of points
%
% Output:
%  z =  c(x)
%
% c.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global ccase

if (ccase == 1)
   z = zeros(size(x));
elseif (ccase == 2)
   z = 2*ones(size(x));
else
   z = 2*x;
end

