function z = fxquad(xpts,h,xend)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = fxquad(xpts,h,xend)
% This function  computes values of the quadratic finite element 
% basis function psi(x) multiplied by a function f(x). 
% It is called by quad in forming the right-hand side for a 
%   finite element problem.
%
% Input:
%  xpts is a row or column vector of points
%  abs(h) is the distance between meshpoints.
%  xend is an endpoint of the interval over which 
%      the function is nonzero.
%
% The definition of psi is 
%             psi(x) = -4 (x - xend)(x - (xend+h))/h^2.
%
% Outputs:
%  z =  f(x) .* psi(x)
%
% fxquad.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

psi = -4*(xpts-xend).*(xpts-(xend+h))/h^2;

z = f(xpts).*psi;
