function [u,up,upp] = trueu(x)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [u,up,upp] = trueu(x)
% This function  computes the true solution for 
% for the differential equation
%   -(a(x) u'(x))' + c(x) u(x) = f(x)  for x in (0,1)
% with u(0)=u(1)=0.
%
% It is used to check the codes in this homework assignment,
% and three cases are given, depending on the value of the
% global variable ucase.
%
% Input:
%  x is a row or column vector of points
%
% Outputs:
%  u  =  u(x)
%  up  = u'(x)
%  upp = u''(x)
%
% trueu.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global ucase

ubase   = x.*(1 - x).*exp(x);
ubasep  = (1 - x - x.*x).*exp(x);
ubasepp = (-3*x -x.*x).*exp(x);
if (ucase == 1)
   u   = ubase;
   up  = ubasep;
   upp = ubasepp;
elseif (ucase == 2)
   u   = (x <= 2/3).*ubase   + (x > 2/3).*x.*(1-x)*exp(2/3);
   up  = (x <= 2/3).*ubasep  + (x > 2/3).* (1-2*x)*exp(2/3);
   upp = (x <= 2/3).*ubasepp + (x > 2/3).* (-2)   *exp(2/3);
else
   u   = (x <= 2/3).*ubase   + (x > 2/3).*x.*(1-x);
   up  = (x <= 2/3).*ubasep  + (x > 2/3).*(1-2*x);
   upp = (x <= 2/3).*ubasepp + (x > 2/3).*(-2);
end
