function val = quadmcqr(a)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function val = quadmcqr(a)
% For each value in a, this function produces a Monte-Carlo
% estimate of the integral over myd dimensional space of 
% the partition function.  The limits of integration are
% taken to be a-mybnd/sqrt(myd) and a+mybnd/sqrt(myd).
% quadmcqr.m Dianne P. O'Leary   09/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global myd mya zsamples mynsamples mybnd

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize the bound for the integration.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bnd = mybnd*ones(1,myd)/sqrt(myd);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Evaluate the integral for each entry in a.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:length(a),
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize mya for the function partition.
% Set the bounds lo and up for the integration.
% Translate the random samples to the myd-dimensional
% box with limits [lo,up], and evaluate the function samples.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  mya = a(i);
  
  lo = -bnd + mya;
  up =  bnd + mya;
  
  ssamples = ones(mynsamples,1)*lo  ...
       + (ones(mynsamples,1)*(up-lo)).*zsamples(1:mynsamples,1:myd);

  fsamples = partition(ssamples);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The estimate of the integral is 
% (the volume of the box lo <= x <= up) 
%              * (the average function value)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  val(i) = prod(up-lo)*sum(fsamples)/mynsamples;

end

