function [counts,t] = latticecount(n)
% counts the number of n*n lattices with k dimers for all values of k
% input:
%   n: the length of one side of the square dimer
% output: c: the count
%         t: the time in seconds
% Thomas DuBois 10/2006 (with some comments added by DPO)

tic
A=zeros(1,n); % the current row is empty so far
clear memo; % create the array for memoizing
global memo; 
memo=-ones(2^n,n^2/2+1,n,n);

counts=latticecounthelper(n,A,1,1); % start the helper in the first position
t=toc;
