function f = rabfox(t,y)
% Computes y' for the Volterra model for the
% population of rabbits and foxes.
% The model is
%    r' = 2 r - alpha r f
%    f' = - f + alpha r f
% The parameter alpha is the encounter factor.
% y(1) is the number of rabbits at time t.
% y(2) is the number of foxes at time t.
% Dianne P. O'Leary 04/2008

global alpha % interaction constant

f(1,1) = 2*y(1) - alpha*y(1)*y(2);
f(2,1) = -y(2) + alpha*y(1)*y(2);

