% This program runs the Volterra model for the
% population of rabbits and foxes and plots the
% results as a phase diagram.
% The model is
%    r' = 2 r - alpha r f
%    f' = - f + alpha r f
% with initial conditions r(0) = 20, f(0) = 10.
% The parameter alpha is the encounter factor
% and it is set to 1, 0.1, and 0.01.
% Dianne P. O'Leary  04/2008

global alpha
k=0

for i=0:1:2,
   alpha = 10^(-i)  
   [t,y] = ode45(@rabfox,[0:.1:7], [20,10]);   
   k = k + 1;
   subplot(3,2,k)
   plot(t,y(:,1),'b',t,y(:,2),'r');
   legend('rabbits','foxes')
   title(sprintf('Population vs time, alpha = %f',alpha));
   k = k + 1;
   subplot(3,2,k)
   plot(y(:,1),y(:,2));
   xlabel('rabbits')
   ylabel('foxes')
   title(sprintf('Phaseplane plot, alpha = %f',alpha));
   disp('Pausing. Press any key to continue.')
   pause
end
